/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.mex.client;

import com.sun.xml.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.ws.mex.MessagesMessages;
import com.sun.xml.ws.mex.client.HttpPoster;
import com.sun.xml.ws.mex.client.MetadataClient;
import com.sun.xml.ws.mex.client.schema.Metadata;
import com.sun.xml.ws.mex.client.schema.MetadataReference;
import com.sun.xml.ws.mex.client.schema.MetadataSection;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptorImpl
extends ServiceDescriptor {
    private final List<Source> wsdls = new ArrayList<Source>();
    private final List<Source> schemas = new ArrayList<Source>();
    private final List<Node> importsToPatch = new ArrayList<Node>();
    private final Map<String, String> nsToSysIdMap = new HashMap<String, String>();
    private static final String LOCATION = "location";
    private static final String NAMESPACE = "namespace";
    private static final Logger logger = Logger.getLogger(ServiceDescriptorImpl.class.getName());

    public ServiceDescriptorImpl(Metadata mData) {
        this.populateLists(mData);
        if (!this.importsToPatch.isEmpty()) {
            this.patchImports();
        }
    }

    private void populateLists(Metadata mData) {
        for (MetadataSection section : mData.getMetadataSection()) {
            if (section.getMetadataReference() != null) {
                this.handleReference(section);
                continue;
            }
            if (section.getLocation() != null) {
                this.handleLocation(section);
                continue;
            }
            this.handleXml(section);
        }
    }

    private void handleXml(MetadataSection section) {
        String dialect = section.getDialect();
        String identifier = section.getIdentifier();
        if (dialect.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.wsdls.add(this.createSource(section, identifier));
        } else if (dialect.equals("http://www.w3.org/2001/XMLSchema")) {
            this.schemas.add(this.createSource(section, identifier));
        } else {
            logger.warning(MessagesMessages.MEX_0002_UNKNOWN_DIALECT_WITH_ID(dialect, identifier));
        }
    }

    private void handleReference(MetadataSection section) {
        MetadataReference ref = section.getMetadataReference();
        this.populateLists(new MetadataClient().retrieveMetadata(ref));
    }

    private void handleLocation(MetadataSection section) {
        String location = section.getLocation();
        String dialect = section.getDialect();
        String identifier = section.getIdentifier();
        if (dialect.equals("http://schemas.xmlsoap.org/wsdl/")) {
            this.wsdls.add(this.getSourceFromLocation(location, identifier));
        } else if (dialect.equals("http://www.w3.org/2001/XMLSchema")) {
            this.schemas.add(this.getSourceFromLocation(location, identifier));
        } else {
            logger.warning(MessagesMessages.MEX_0002_UNKNOWN_DIALECT_WITH_ID(dialect, identifier));
        }
    }

    public List<Source> getWSDLs() {
        return this.wsdls;
    }

    public List<Source> getSchemas() {
        return this.schemas;
    }

    private Source createSource(MetadataSection section, String identifier) {
        Node node = (Node)section.getAny();
        String sysId = identifier;
        if (section.getDialect().equals("http://schemas.xmlsoap.org/wsdl/")) {
            String targetNamespace = this.getNamespaceFromNode(node);
            if (sysId == null) {
                sysId = targetNamespace;
            }
            this.nsToSysIdMap.put(targetNamespace, sysId);
            this.checkWsdlImports(node);
        } else if (sysId == null) {
            sysId = this.getNamespaceFromNode(node);
        }
        DOMSource source = new DOMSource(node);
        source.setSystemId(sysId);
        return source;
    }

    private Source getSourceFromLocation(String address, String identifier) {
        try {
            HttpPoster poster = new HttpPoster();
            InputStream response = poster.makeGetCall(address);
            if (identifier != null) {
                StreamSource source = new StreamSource(response);
                source.setSystemId(identifier);
                return source;
            }
            return this.parseAndConvertStream(address, response);
        }
        catch (IOException ioe) {
            String exceptionMessage = MessagesMessages.MEX_0014_RETRIEVAL_FROM_ADDRESS_FAILURE(address);
            logger.log(Level.SEVERE, exceptionMessage, ioe);
            throw new WebServiceException(exceptionMessage, ioe);
        }
    }

    private String getNamespaceFromNode(Node node) {
        Node namespace = node.getAttributes().getNamedItem("targetNamespace");
        if (namespace == null) {
            logger.warning(MessagesMessages.MEX_0003_UNKNOWN_WSDL_NAMESPACE(node.getNodeName()));
            return null;
        }
        return namespace.getNodeValue();
    }

    private void checkWsdlImports(Node wsdl) {
        NodeList kids = wsdl.getChildNodes();
        for (int i = 0; i < kids.getLength(); ++i) {
            Node location;
            Node importNode = kids.item(i);
            if (importNode.getLocalName() == null || !importNode.getLocalName().equals("import") || (location = importNode.getAttributes().getNamedItem(LOCATION)) != null) continue;
            this.importsToPatch.add(importNode);
        }
    }

    private Source parseAndConvertStream(String address, InputStream stream) {
        try {
            Transformer xFormer = TransformerFactory.newInstance().newTransformer();
            Source source = new StreamSource(stream);
            DOMResult result = new DOMResult();
            xFormer.transform(source, result);
            Node wsdlDoc = result.getNode();
            source = new DOMSource(wsdlDoc);
            source.setSystemId(this.getNamespaceFromNode(wsdlDoc.getFirstChild()));
            return source;
        }
        catch (TransformerException te) {
            String exceptionMessage = MessagesMessages.MEX_0004_TRANSFORMING_FAILURE(address);
            logger.log(Level.SEVERE, exceptionMessage, te);
            throw new WebServiceException(exceptionMessage, te);
        }
    }

    private void patchImports() throws DOMException {
        for (Node importNode : this.importsToPatch) {
            NamedNodeMap atts = importNode.getAttributes();
            String targetNamespace = atts.getNamedItem(NAMESPACE).getNodeValue();
            String sysId = this.nsToSysIdMap.get(targetNamespace);
            if (sysId == null) {
                logger.warning(MessagesMessages.MEX_0005_WSDL_NOT_FOUND_WITH_NAMESPACE(targetNamespace));
                continue;
            }
            Attr locationAtt = importNode.getOwnerDocument().createAttribute(LOCATION);
            locationAtt.setValue(sysId);
            atts.setNamedItem(locationAtt);
        }
    }
}

