/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.assembler.ActionDumpTubeAppender;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.messagedump.MessageDumpingTubeAppender;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.rm.runtime.RmTubeAppender;
import com.sun.xml.ws.rm.runtime.testing.PacketFilteringTubeAppender;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import com.sun.xml.ws.transport.tcp.wsit.TCPTransportPipeFactory;
import com.sun.xml.ws.tx.client.TxClientPipe;
import com.sun.xml.ws.tx.common.Util;
import com.sun.xml.ws.tx.service.TxServerPipe;
import com.sun.xml.wss.provider.wsit.SecurityTubeAppender;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TubelineAssemblyController {
    private static final String BEFORE_SUFFIX = ".before";
    private static final String AFTER_SUFFIX = ".after";
    private static final String TRANSPORT_SUFFIX = ".transport";
    private static final String WSS_SUFFIX = ".wss";
    private static final String WSA_SUFFIX = ".wsa";
    private static final String WSRM_SUFFIX = ".wsrm";
    private static final String WSTX_SUFFIX = ".wstx";
    private static final TubeAppender transportAppender = new TransportTubeAppender();
    private static final TubeAppender messageDumpingAppender = new MessageDumpingTubeAppender();
    private static final TubeAppender packetFilteringAppender = new PacketFilteringTubeAppender();
    private static final TubeAppender actionDumpAppender = new ActionDumpTubeAppender();
    private static final TubeAppender securityAppender = new SecurityTubeAppender();
    private static final TubeAppender reliableMessagingAppender = new RmTubeAppender();
    private static final TubeAppender transactionsAppender = new TxTubeAppender();
    private static final TubeAppender addressingAppender = new AddressingTubeAppender();
    private static final TubeAppender monitoringAppender = new MonitoringTubeAppender();
    private static final TubeAppender mustUnderstandAppender = new MustUnderstandTubeAppender();
    private static final TubeAppender validationAppender = new ValidationTubeAppender();
    private static final TubeAppender handlerAppender = new HandlerTubeAppender();
    private static final TubeAppender terminalAppender = new TerminalTubeAppender();
    private static final TubeAppender[] clientAppenders = new TubeAppender[]{transportAppender, messageDumpingAppender, packetFilteringAppender, new DumpTubeAppender(""), actionDumpAppender, new DumpTubeAppender(".transport"), new DumpTubeAppender(".wss.after"), securityAppender, new DumpTubeAppender(".wss.before"), new DumpTubeAppender(".wsrm.after"), reliableMessagingAppender, new DumpTubeAppender(".wsrm.before"), new DumpTubeAppender(".wstx.after"), transactionsAppender, new DumpTubeAppender(".wstx.before"), new DumpTubeAppender(".wsa.after"), addressingAppender, new DumpTubeAppender(".wsa.before"), monitoringAppender, mustUnderstandAppender, validationAppender, handlerAppender};
    private static final TubeAppender[] serverAppenders = new TubeAppender[]{terminalAppender, validationAppender, handlerAppender, mustUnderstandAppender, monitoringAppender, new DumpTubeAppender(".wstx.after"), transactionsAppender, new DumpTubeAppender(".wstx.before"), new DumpTubeAppender(".wsrm.after"), reliableMessagingAppender, new DumpTubeAppender(".wsrm.before"), new DumpTubeAppender(".wsa.after"), addressingAppender, new DumpTubeAppender(".wsa.before"), new DumpTubeAppender(".wss.after"), securityAppender, new DumpTubeAppender(".wss.before"), new DumpTubeAppender(".transport"), actionDumpAppender, new DumpTubeAppender(""), packetFilteringAppender, messageDumpingAppender};

    public Collection<TubeAppender> getClientSideAppenders() {
        return Arrays.asList(clientAppenders);
    }

    public Collection<TubeAppender> getServerSideAppenders() {
        return Arrays.asList(serverAppenders);
    }

    public static class TerminalTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().getTerminalTube();
        }
    }

    public static class HandlerTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createHandlerTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createHandlerTube(context.getTubelineHead());
        }
    }

    public static class ValidationTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createValidationTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createValidationTube(context.getTubelineHead());
        }
    }

    public static class MustUnderstandTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createClientMUTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createServerMUTube(context.getTubelineHead());
        }
    }

    public static class MonitoringTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createMonitoringTube(context.getTubelineHead());
        }
    }

    public static class AddressingTubeAppender
    implements TubeAppender {
        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createWsaTube(context.getTubelineHead());
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getWrappedContext().createWsaTube(context.getTubelineHead());
        }
    }

    public static class TransportTubeAppender
    implements TubeAppender {
        private static final String AUTO_OPTIMIZED_TRANSPORT_POLICY_NAMESPACE_URI = "http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client";
        private static final QName AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION = new QName("http://java.sun.com/xml/ns/wsit/2006/09/policy/transport/client", "AutomaticallySelectOptimalTransport");

        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (this.isOptimizedTransportEnabled(context.getPolicyMap(), context.getWsdlPort(), context.getPortInfo())) {
                return TCPTransportPipeFactory.doCreate(context, false);
            }
            return context.getWrappedContext().createTransportTube();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            return context.getTubelineHead();
        }

        private boolean isOptimizedTransportEnabled(PolicyMap policyMap, WSDLPort port, WSPortInfo portInfo) {
            QName portName;
            QName serviceName;
            String schema;
            if (policyMap == null || port == null && portInfo == null) {
                return false;
            }
            if (port != null) {
                schema = port.getAddress().getURI().getScheme();
                serviceName = port.getOwner().getName();
                portName = port.getName();
            } else {
                schema = portInfo.getEndpointAddress().getURI().getScheme();
                serviceName = portInfo.getServiceName();
                portName = portInfo.getPortName();
            }
            if ("vnd.sun.ws.tcp".equals(schema)) {
                return true;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(serviceName, portName);
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && policy.contains(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION) && policy.contains(AUTO_OPTIMIZED_TRANSPORT_POLICY_ASSERTION)) {
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_POLICY_ASSERTION)) continue;
                            String value = assertion.getAttributeValue(new QName("enabled"));
                            if (value == null) {
                                return false;
                            }
                            return Boolean.valueOf(value = value.trim()) != false || value.equalsIgnoreCase("yes");
                        }
                    }
                }
                return false;
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
        }
    }

    public static class DumpTubeAppender
    implements TubeAppender {
        public static final String PREFIX = "com.sun.xml.ws.assembler";
        public static final String CLIENT_PREFIX = "com.sun.xml.ws.assembler.client";
        public static final String SERVER_PREFIX = "com.sun.xml.ws.assembler.server";
        private final String name;

        public DumpTubeAppender(String name) {
            this.name = name;
        }

        public Tube appendTube(WsitClientTubeAssemblyContext context) throws WebServiceException {
            if (Boolean.getBoolean(CLIENT_PREFIX + this.name)) {
                return context.getWrappedContext().createDumpTube(this.name, System.out, context.getTubelineHead());
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) throws WebServiceException {
            if (Boolean.getBoolean(SERVER_PREFIX + this.name)) {
                return context.getWrappedContext().createDumpTube(this.name, System.out, context.getTubelineHead());
            }
            return context.getTubelineHead();
        }
    }

    public static class TxTubeAppender
    implements TubeAppender {
        private static final String WSAT_SOAP_NSURI = "http://schemas.xmlsoap.org/ws/2004/10/wsat";
        private static final QName AT_ALWAYS_CAPABILITY = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAlwaysCapability");
        private static final QName AT_ASSERTION = new QName("http://schemas.xmlsoap.org/ws/2004/10/wsat", "ATAssertion");

        public Tube appendTube(WsitClientTubeAssemblyContext context) {
            if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), false)) {
                return PipeAdapter.adapt(new TxClientPipe(context, context.getAdaptedTubelineHead()));
            }
            return context.getTubelineHead();
        }

        public Tube appendTube(WsitServerTubeAssemblyContext context) {
            if (this.isTransactionsEnabled(context.getPolicyMap(), context.getWsdlPort(), true)) {
                return PipeAdapter.adapt(new TxServerPipe(context, context.getAdaptedTubelineHead()));
            }
            return context.getTubelineHead();
        }

        private boolean isTransactionsEnabled(PolicyMap policyMap, WSDLPort wsdlPort, boolean isServerSide) {
            if (policyMap == null || wsdlPort == null || !Util.isJTAAvailable()) {
                return false;
            }
            try {
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                for (WSDLBoundOperation wSDLBoundOperation : wsdlPort.getBinding().getBindingOperations()) {
                    PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey(wsdlPort.getOwner().getName(), wsdlPort.getName(), wSDLBoundOperation.getName());
                    policy = policyMap.getOperationEffectivePolicy(operationKey);
                    if (policy == null) continue;
                    if (isServerSide && policy.contains(AT_ALWAYS_CAPABILITY)) {
                        return true;
                    }
                    if (!policy.contains(AT_ASSERTION)) continue;
                    return true;
                }
            }
            catch (PolicyException e) {
                throw new WebServiceException(e);
            }
            return false;
        }
    }
}

