/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.db.sdo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SDODatabindingSchemaResolver
extends DefaultSchemaResolver {
    public static final String CLASSPATH_SCHEME = "classpath";
    private List<Source> schemaList = null;
    private EntityResolver externalResolver = null;

    public SDODatabindingSchemaResolver(List<Source> schemas) {
        this.schemaList = schemas;
    }

    public SDODatabindingSchemaResolver(List<Source> schemas, EntityResolver resolver) {
        this.schemaList = schemas;
        this.externalResolver = resolver;
    }

    public Source resolveSchema(Source sourceXSD, String namespace, String schemaLocation) {
        if (schemaLocation == null) {
            return null;
        }
        Source source = null;
        try {
            if (sourceXSD != null && sourceXSD.getSystemId() != null) {
                InputSource inputSource;
                URI baseURI = new URI(sourceXSD.getSystemId());
                String scheme = null;
                if (baseURI.isOpaque()) {
                    scheme = baseURI.getScheme();
                    baseURI = new URI(baseURI.getRawSchemeSpecificPart());
                }
                URI schemaLocationURI = baseURI.resolve(schemaLocation);
                if (scheme != null) {
                    schemaLocationURI = new URI(scheme + ":" + schemaLocationURI);
                }
                if ((source = this.loadSourceFromKnownSchemas(this.schemaList, schemaLocationURI)) != null) {
                    return source;
                }
                source = this.loadSourceFromURL(schemaLocationURI.toURL());
                if (source == null && this.externalResolver != null && (inputSource = this.externalResolver.resolveEntity(schemaLocation, schemaLocationURI.toASCIIString())) != null) {
                    source = new SAXSource(inputSource);
                }
            } else {
                System.out.println("Base URI for " + schemaLocation + " can not be determined because source schema does not have systemID set");
            }
        }
        catch (Exception ee) {
            System.out.println("Exception trying to resolve schema for " + schemaLocation + ": " + ee.getMessage());
        }
        if (source == null) {
            source = this.loadSourceFromClasspath(schemaLocation);
        }
        if (source == null) {
            System.out.println("Unable to resolve requested schema resource [" + schemaLocation + "]");
        }
        return source;
    }

    private Source loadSourceFromKnownSchemas(List<Source> schemas, URI schemaLocation) {
        if (schemas == null) {
            return null;
        }
        for (Source schema : schemas) {
            String sysId = schema.getSystemId();
            if (sysId == null || !sysId.equals(schemaLocation.toASCIIString())) continue;
            return schema;
        }
        return null;
    }

    private Source loadSourceFromClasspath(String schemaLocation) {
        URL url;
        if (schemaLocation.startsWith(CLASSPATH_SCHEME)) {
            schemaLocation = schemaLocation.substring(CLASSPATH_SCHEME.length() + 1);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(schemaLocation)) == null && schemaLocation.startsWith("/")) {
            url = Thread.currentThread().getContextClassLoader().getResource(schemaLocation.substring(1));
        }
        if (url != null) {
            return this.loadSourceFromURL(url);
        }
        return null;
    }

    private Source loadSourceFromURL(URL targetURL) {
        StreamSource targetXSD = null;
        try {
            InputStream is = targetURL.openStream();
            targetXSD = new StreamSource(is);
            targetXSD.setSystemId(targetURL.toExternalForm());
        }
        catch (IOException e) {
            System.out.println("failed to load source from URL:" + targetURL + ": " + e.getMessage());
            return null;
        }
        return targetXSD;
    }
}

