/*
 * Copyright (c) 1997, 2022 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.server;

import com.sun.xml.ws.developer.ValidationErrorHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXException;

/**
 * Default {@link ValidationErrorHandler} that just rethrows SAXException
 * in case of errors.
 *
 * @author Jitendra Kotamraju
 */
public class DraconianValidationErrorHandler extends ValidationErrorHandler {

    /**
     * Default constructor.
     */
    public DraconianValidationErrorHandler() {}

    @Override
    public void warning(SAXParseException e) throws SAXException {
        // noop
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

}
