/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.xml.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class SenderMessages {

    private static final String BUNDLE_NAME = "com.sun.xml.ws.resources.sender";
    private static final LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new SenderMessages.BundleSupplier());
    private static final Localizer LOCALIZER = new Localizer();

    private SenderMessages() {
    }

    public static Localizable localizableSENDER_REQUEST_MESSAGE_NOT_READY() {
        return MESSAGE_FACTORY.getMessage("sender.request.messageNotReady");
    }

    /**
     * message not ready to be sent
     * 
     */
    public static String SENDER_REQUEST_MESSAGE_NOT_READY() {
        return LOCALIZER.localize(localizableSENDER_REQUEST_MESSAGE_NOT_READY());
    }

    public static Localizable localizableSENDER_RESPONSE_CANNOT_DECODE_FAULT_DETAIL() {
        return MESSAGE_FACTORY.getMessage("sender.response.cannotDecodeFaultDetail");
    }

    /**
     * fault detail cannot be decoded
     * 
     */
    public static String SENDER_RESPONSE_CANNOT_DECODE_FAULT_DETAIL() {
        return LOCALIZER.localize(localizableSENDER_RESPONSE_CANNOT_DECODE_FAULT_DETAIL());
    }

    public static Localizable localizableSENDER_REQUEST_ILLEGAL_VALUE_FOR_CONTENT_NEGOTIATION(Object arg0) {
        return MESSAGE_FACTORY.getMessage("sender.request.illegalValueForContentNegotiation", arg0);
    }

    /**
     * illegal value for content negotiation property "{0}"
     * 
     */
    public static String SENDER_REQUEST_ILLEGAL_VALUE_FOR_CONTENT_NEGOTIATION(Object arg0) {
        return LOCALIZER.localize(localizableSENDER_REQUEST_ILLEGAL_VALUE_FOR_CONTENT_NEGOTIATION(arg0));
    }

    public static Localizable localizableSENDER_NESTED_ERROR(Object arg0) {
        return MESSAGE_FACTORY.getMessage("sender.nestedError", arg0);
    }

    /**
     * sender error: {0}
     * 
     */
    public static String SENDER_NESTED_ERROR(Object arg0) {
        return LOCALIZER.localize(localizableSENDER_NESTED_ERROR(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
