/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.DeploymentDescriptorParser;
import com.sun.xml.ws.transport.http.ResourceLoader;
import com.sun.xml.ws.transport.local.FileSystemResourceLoader;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;

public class WSDLGen {
    public static boolean useLocal() {
        return Boolean.getBoolean("uselocal");
    }

    public static void main(String[] args) throws Exception {
        System.exit(WSDLGen.run());
    }

    public static int run() throws Exception {
        if (!WSDLGen.useLocal()) {
            return 0;
        }
        String outputDir = System.getProperty("tempdir");
        if (outputDir == null) {
            System.err.println("**** Set tempdir system property ****");
            return -1;
        }
        String riFile = outputDir + "/WEB-INF/sun-jaxws.xml";
        DeploymentDescriptorParser parser = new DeploymentDescriptorParser(Thread.currentThread().getContextClassLoader(), (ResourceLoader)new FileSystemResourceLoader(new File(outputDir)), null, (DeploymentDescriptorParser.AdapterFactory)new DeploymentDescriptorParser.AdapterFactory<WSEndpoint>(){

            public WSEndpoint createAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
                return endpoint;
            }
        });
        List endpoints = parser.parse(new File(riFile));
        String addr = new File(outputDir).toURI().toURL().toExternalForm();
        final String address = "local" + addr.substring(4);
        for (WSEndpoint endpoint : endpoints) {
            ServiceDefinition def = endpoint.getServiceDefinition();
            if (def == null) continue;
            SDDocument primary = def.getPrimary();
            File file = new File(primary.getURL().toURI());
            if (file.exists()) {
                System.out.println("**** Primary WSDL " + file + " already exists - not generating any WSDL artifacts ****");
                continue;
            }
            for (SDDocument doc : def) {
                int index = doc.getURL().getFile().indexOf("/WEB-INF/wsdl");
                Object name = "";
                name = index == -1 ? outputDir + "/WEB-INF/wsdl" + doc.getURL().getFile() : doc.getURL().getFile();
                System.out.println("Creating WSDL artifact=" + (String)name);
                ByteArrayBuffer buffer = new ByteArrayBuffer();
                doc.writeTo(new PortAddressResolver(){

                    public String getAddressFor(QName serviceName, String portName) {
                        return address;
                    }
                }, new DocumentAddressResolver(){

                    public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
                        String rel = referenced.getURL().toExternalForm();
                        return rel.substring(6);
                    }
                }, (OutputStream)buffer);
                FileOutputStream fos = new FileOutputStream((String)name);
                buffer.writeTo((OutputStream)fos);
                fos.close();
            }
        }
        return 0;
    }
}

