/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JRunner
extends Task {
    private boolean local;
    private String contentNegotiation;
    private String targets;
    protected boolean verbose = false;
    protected boolean failonerror = false;
    protected List<FileSet> buildFileFileset = new ArrayList<FileSet>();

    public boolean getLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getContentNegotiation() {
        return this.contentNegotiation;
    }

    public void setContentNegotiation(String contentNegotiation) {
        this.contentNegotiation = contentNegotiation;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addConfiguredBuildFile(FileSet fileset) {
        this.buildFileFileset.add(fileset);
    }

    void prepareBuildFileList(Set<File> buildFileFiles) throws BuildException {
        if (this.buildFileFileset != null) {
            for (FileSet fileset : this.buildFileFileset) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
                String[] includedFiles = ds.getIncludedFiles();
                File baseDir = ds.getBasedir();
                for (int i = 0; i < includedFiles.length; ++i) {
                    buildFileFiles.add(new File(baseDir, includedFiles[i]));
                }
            }
        }
    }

    public void execute() throws BuildException {
        HashSet<File> buildFileFiles = new HashSet<File>();
        this.prepareBuildFileList(buildFileFiles);
        int count = 0;
        for (File buildFile : buildFileFiles) {
            this.log(++count + "th build file: " + buildFile.getAbsolutePath());
            Project project = new Project();
            this.initializeProject(project, buildFile);
            project.setProperty("uselocal", String.valueOf(this.getLocal()));
            if (this.contentNegotiation != null && this.contentNegotiation.length() > 0) {
                project.setProperty("contentNegotiation", this.getContentNegotiation());
            }
            StringTokenizer tokens = new StringTokenizer(this.getTargets(), ",");
            while (tokens.hasMoreTokens()) {
                String target = tokens.nextToken().trim();
                if (this.verbose) {
                    this.log("Invoking ... " + target);
                }
                try {
                    project.executeTarget(target);
                }
                catch (BuildException ex) {
                    if (!this.failonerror) continue;
                    throw ex;
                }
            }
        }
    }

    private void initializeProject(Project project, File buildFile) {
        project.init();
        DefaultLogger consoleLogger = new DefaultLogger();
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)consoleLogger);
        project.setUserProperty("ant.file", buildFile.getAbsolutePath());
        ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
        projectHelper.parse(project, (Object)buildFile);
    }
}

