/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Assert;

public class CalendarComparator
extends Assert {
    public static boolean compareCalendars(Calendar cal1, Calendar cal2) throws Exception {
        if (cal1 == cal2) {
            return true;
        }
        if (cal1 == null && cal2 != null || cal1 != null && cal2 == null) {
            return false;
        }
        if (!CalendarComparator.compareCalendarStrings(cal1, cal2)) {
            return false;
        }
        Method getDSTSavingsMethod = TimeZone.getDefault().getClass().getMethod("getDSTSavings", null);
        return cal1.getTime().equals(cal2.getTime());
    }

    public static boolean compareCalendarByTime(Calendar cal1, Calendar cal2) throws Exception {
        if (cal1 == cal2) {
            return true;
        }
        if (cal1 == null && cal2 != null || cal1 != null && cal2 == null) {
            return false;
        }
        return cal1.getTime().equals(cal2.getTime());
    }

    public static void assertCalendarsAreEqual(Calendar cal1, Calendar cal2) throws Exception {
        if (cal1 == cal2) {
            return;
        }
        if (cal1 == null) {
            CalendarComparator.assertNull((String)"expected null calendar", (Object)cal2);
            return;
        }
        CalendarComparator.assertNotNull((String)"expected non-null calendar", (Object)cal2);
        String cal1String = CalendarComparator.getCalendarString(cal1);
        String cal2String = CalendarComparator.getCalendarString(cal2);
        if (!cal1String.equals(cal2String)) {
            CalendarComparator.fail((String)("Excpected calendar: " + cal1String + " but got: " + cal2String));
        }
        Method getDSTSavingsMethod = TimeZone.getDefault().getClass().getMethod("getDSTSavings", null);
        if (!cal1.getTime().equals(cal2.getTime())) {
            CalendarComparator.fail((String)("Expected date of: " + cal1.getTime() + " but got: " + cal2.getTime()));
        }
    }

    public static boolean compareCalendarStrings(Calendar cal1, Calendar cal2) throws Exception {
        boolean succeed = CalendarComparator.getCalendarString(cal1).equals(CalendarComparator.getCalendarString(cal2));
        if (!succeed) {
            System.out.println("cal1: \"" + CalendarComparator.getCalendarString(cal1) + "\"");
            System.out.println("cal2: \"" + CalendarComparator.getCalendarString(cal2) + "\"");
        }
        return succeed;
    }

    public static String getCalendarString(Calendar cal) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z G");
        TimeZone tmpzone = cal.getTimeZone();
        tmpzone.setID("Custom");
        df.setTimeZone(tmpzone);
        return df.format(cal.getTime());
    }

    public static boolean compareCalendarArrays(Object[] arr1, Object[] arr2) throws Exception {
        boolean retVal = true;
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length && retVal; ++i) {
            if (arr1[i] instanceof Date || arr2[i] instanceof Date) {
                Date date1 = arr1[i] instanceof Date ? (Date)arr1[i] : ((Calendar)arr1[i]).getTime();
                Date date2 = arr2[i] instanceof Date ? (Date)arr2[i] : ((Calendar)arr2[i]).getTime();
                retVal = date1.equals(date2);
            } else {
                retVal = CalendarComparator.compareCalendars((Calendar)arr1[i], (Calendar)arr2[i]);
            }
            if (retVal) continue;
            System.out.println("arr1: " + arr1[i]);
            System.out.println();
            System.out.println("arr2: " + arr2[i]);
        }
        return retVal;
    }

    public static boolean compareCalendarArraysByDate(Object[] arr1, Object[] arr2) throws Exception {
        boolean retVal = true;
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length && retVal; ++i) {
            Date date2;
            Date date1 = arr1[i] instanceof Date ? (Date)arr1[i] : ((Calendar)arr1[i]).getTime();
            retVal = date1.equals(date2 = arr2[i] instanceof Date ? (Date)arr2[i] : ((Calendar)arr2[i]).getTime());
            if (retVal) continue;
            System.out.println("arr1: " + arr1[i]);
            System.out.println();
            System.out.println("arr2: " + arr2[i]);
        }
        return retVal;
    }
}

