/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import com.sun.tools.ws.wsdl.parser.Util;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class LocalCustomizationFileTransformer {
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.err.println("ERROR: need args: old config file location,\nwsdl name");
            return;
        }
        try {
            StringTokenizer tokenizer;
            Map<String, String> map = null;
            if (args.length > 1) {
                File wsdlLocationFile = new File(args[2]);
                File newLoc = new File(args[1] + "WEB-INF/wsdl/" + wsdlLocationFile.getName());
                map = LocalCustomizationFileTransformer.buildMap(new File(args[1] + "WEB-INF/wsdl/").getCanonicalPath(), newLoc.getCanonicalPath());
            }
            int index = args[0].lastIndexOf(47);
            String path = "./";
            String files = args[0];
            if (index != -1) {
                path = args[0].substring(0, index + 1);
                files = args[0].substring(index + 1);
            }
            if (!(tokenizer = new StringTokenizer(files, ",")).hasMoreTokens()) {
                tokenizer = new StringTokenizer(files, " ");
            }
            while (tokenizer.hasMoreTokens()) {
                String location;
                String token = tokenizer.nextToken().trim();
                String oldCustom = path + token;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = dbf.newDocumentBuilder();
                File file = new File(oldCustom);
                Document doc = builder.parse(file);
                Element wsdlElement = doc.getDocumentElement();
                String localName = wsdlElement.getLocalName();
                String nspace = wsdlElement.getNamespaceURI();
                if (localName != null && localName.equals("bindings") && nspace != null && !wsdlElement.getNamespaceURI().equals("http://java.sun.com/xml/ns/jaxws")) continue;
                Attr wsdlAttr = wsdlElement.getAttributeNode("wsdlLocation");
                String string = location = wsdlAttr != null ? wsdlAttr.getValue() : null;
                if (location != null) {
                    if (args.length == 1) {
                        System.out.println(location);
                        return;
                    }
                    token = "temp-config.xml";
                }
                String newCustom = args[1] + token;
                if (location != null) {
                    File wsdlLocationFile = new File(args[2]);
                    File newLoc = new File(args[1] + "WEB-INF/wsdl/" + wsdlLocationFile.getName());
                    wsdlAttr.setValue(newLoc.getCanonicalPath());
                    System.out.println(newLoc.getCanonicalPath());
                } else {
                    LocalCustomizationFileTransformer.transformSchemaLocation(wsdlElement, map);
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(newCustom));
            }
        }
        catch (Exception e) {
            System.err.println("exception in LocalConfigFileTransformer:");
            e.printStackTrace();
        }
    }

    private static Attr getWSDLLocation(Element root) {
        NamedNodeMap atts = root.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (!a.getLocalName().equals("wsdlLocation")) continue;
            return a;
        }
        return null;
    }

    private static void transformSchemaLocation(Element root, Map<String, String> map) throws IOException {
        Iterator iter = XmlUtil.getAllChildren((Element)root);
        while (iter.hasNext()) {
            String sl;
            int index;
            Element e = Util.nextElement((Iterator)iter);
            if (e == null) {
                return;
            }
            Attr schemaLocationAttr = e.getAttributeNode("schemaLocation");
            if (schemaLocationAttr == null || (index = (sl = schemaLocationAttr.getValue()).lastIndexOf(63)) == -1) continue;
            schemaLocationAttr.setValue("file:/" + map.get(sl.substring(index + 1)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, String> buildMap(String dirName, String primaryWsdl) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> schemaIds = new ArrayList<String>();
        ArrayList<String> wsdlIds = new ArrayList<String>();
        File dir = new File(dirName);
        ArrayList<String> list = new ArrayList<String>();
        LocalCustomizationFileTransformer.buildDocList(dir, list);
        for (String string : list) {
            if (string.endsWith(".wsdl")) {
                if (!string.equals(primaryWsdl)) {
                    wsdlIds.add(string);
                    continue;
                }
                map.put("wsdl", string);
                continue;
            }
            if (!string.endsWith(".xsd")) continue;
            schemaIds.add(string);
        }
        Collections.sort(wsdlIds);
        Collections.sort(schemaIds);
        int wsdlNum = 1;
        for (String string : wsdlIds) {
            map.put("wsdl=" + wsdlNum++, string);
        }
        boolean bl = true;
        for (String string : schemaIds) {
            void var8_12;
            map.put("xsd=" + (int)(++var8_12), string);
        }
        return map;
    }

    private static void buildDocList(File dir, List<String> list) throws Exception {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            File sub = new File(dir, files[i]);
            if (sub.isDirectory()) {
                LocalCustomizationFileTransformer.buildDocList(sub, list);
                continue;
            }
            list.add(sub.getCanonicalPath());
        }
    }
}

