/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MappingJaxrpcRiRuntime {
    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            System.err.println("ERROR: need args: jaxrpc-ri.xml,\nconfig-server.xml,\ntemp dir");
            return;
        }
        try {
            String jaxrpcri = args[0];
            String serverConfig = args[1];
            String newConfig = args[2] + "jaxrpc-ri-runtime.xml";
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document newdoc = builder.newDocument();
            Element root = newdoc.createElement("endpoints");
            newdoc.appendChild(root);
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/jax-rpc/ri/runtime");
            root.setAttribute("version", "1.0");
            Comment comment = newdoc.createComment("This xml file is not created by WsDeploy and is just hand-coded from jaxrpc-ri.xml to run cleints locally");
            root.appendChild(comment);
            Document doc = builder.parse(jaxrpcri);
            Element endpointElement = (Element)doc.getElementsByTagName("endpoint").item(0);
            Attr wsdlAttr = endpointElement.getAttributeNode("wsdl");
            if (wsdlAttr == null) {
                Document doc1 = builder.parse(serverConfig);
                Element serviceElement = (Element)doc1.getElementsByTagName("service").item(0);
                String serviceName = serviceElement.getAttribute("name");
                String wsdlLocation = "/WEB-INF/" + serviceName + ".wsdl";
                endpointElement.setAttribute("wsdl", wsdlLocation);
            }
            Element webServicesElement = (Element)doc.getElementsByTagName("webServices").item(0);
            Element endpointMappingElement = (Element)webServicesElement.getElementsByTagName("endpointMapping").item(0);
            String urlPatternAttr = endpointMappingElement.getAttribute("urlPattern");
            endpointElement.setAttribute("urlpattern", urlPatternAttr);
            Node endpointNode = newdoc.importNode(endpointElement, true);
            root.appendChild(endpointNode);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(newdoc), new StreamResult(newConfig));
        }
        catch (Exception e) {
            System.err.println("exception in JaxrpcRiRuntimeConfigCreator:");
            e.printStackTrace();
        }
    }
}

