/*
 * Decompiled with CFR 0.152.
 */
package testutil;

import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlUtil {
    public static String getPrefix(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return null;
        }
        return s.substring(0, i);
    }

    public static String getLocalPart(String s) {
        int i = s.indexOf(58);
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1);
    }

    public static String getTextForNode(Node node) {
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        if (children.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n instanceof Text) {
                sb.append(n.getNodeValue());
                continue;
            }
            if (n instanceof EntityReference) {
                String s = XmlUtil.getTextForNode(n);
                if (s == null) {
                    return null;
                }
                sb.append(s);
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    public static Element getFirstElementChild(Node parent) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }
}

