/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.parser;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.AbortException;
import com.sun.tools.ws.wscompile.DefaultAuthenticator;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.framework.ParseException;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.InternalizationLogic;
import com.sun.xml.ws.api.wsdl.parser.MetaDataResolver;
import com.sun.xml.ws.api.wsdl.parser.MetadataResolverFactory;
import com.sun.xml.ws.api.wsdl.parser.ServiceDescriptor;
import com.sun.xml.ws.util.DOMUtil;
import com.sun.xml.ws.util.JAXWSUtils;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class MetadataFinder
extends DOMForest {
    public boolean isMexMetadata;
    private String rootWSDL;
    private Set<String> rootWsdls = new HashSet<String>();

    public MetadataFinder(InternalizationLogic logic, WsimportOptions options, ErrorReceiver errReceiver) {
        super(logic, new WSEntityResolver(options, errReceiver), options, errReceiver);
    }

    public void parseWSDL() {
        for (InputSource value : this.options.getWSDLs()) {
            Element doc;
            String systemID = value.getSystemId();
            this.errorReceiver.pollAbort();
            try {
                Document dom;
                if (this.options.entityResolver != null) {
                    value = this.options.entityResolver.resolveEntity(null, systemID);
                }
                if (value == null) {
                    value = new InputSource(systemID);
                }
                if ((doc = (dom = this.parse(value, true)).getDocumentElement()) == null) continue;
                if (doc.getNamespaceURI() == null || !doc.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !doc.getLocalName().equals("definitions")) {
                    throw new SAXParseException(WsdlMessages.INVALID_WSDL(systemID, WSDLConstants.QNAME_DEFINITIONS, doc.getNodeName(), this.locatorTable.getStartLocation(doc).getLineNumber()), this.locatorTable.getStartLocation(doc));
                }
            }
            catch (FileNotFoundException e) {
                this.errorReceiver.error(WsdlMessages.FILE_NOT_FOUND(systemID), e);
                return;
            }
            catch (IOException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            catch (SAXParseException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            catch (SAXException e) {
                doc = this.getFromMetadataResolver(systemID, e);
            }
            if (doc == null) continue;
            NodeList schemas = doc.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
            for (int i = 0; i < schemas.getLength(); ++i) {
                if (this.inlinedSchemaElements.contains(schemas.item(i))) continue;
                this.inlinedSchemaElements.add((Element)schemas.item(i));
            }
        }
        this.identifyRootWsdls();
    }

    @Nullable
    public String getRootWSDL() {
        return this.rootWSDL;
    }

    @NotNull
    public Set<String> getRootWSDLs() {
        return this.rootWsdls;
    }

    private void identifyRootWsdls() {
        for (String location : this.rootDocuments) {
            Element definition;
            Document doc = this.get(location);
            if (doc == null || (definition = doc.getDocumentElement()) == null || definition.getLocalName() == null || definition.getNamespaceURI() == null || !definition.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") || !definition.getLocalName().equals("definitions")) continue;
            this.rootWsdls.add(location);
            NodeList nl = definition.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service");
            if (nl.getLength() <= 0) continue;
            this.rootWSDL = location;
        }
        if (this.rootWSDL == null) {
            StringBuilder strbuf = new StringBuilder();
            for (String str : this.rootWsdls) {
                strbuf.append(str);
                strbuf.append('\n');
            }
            this.errorReceiver.error(null, WsdlMessages.FAILED_NOSERVICE(strbuf.toString()));
        }
    }

    @Nullable
    private Element getFromMetadataResolver(String systemId, Exception ex) {
        ServiceDescriptor serviceDescriptor = null;
        for (MetadataResolverFactory resolverFactory : ServiceFinder.find(MetadataResolverFactory.class)) {
            MetaDataResolver resolver = resolverFactory.metadataResolver(this.options.entityResolver);
            try {
                serviceDescriptor = resolver.resolve(new URI(systemId));
                if (serviceDescriptor == null) continue;
                break;
            }
            catch (URISyntaxException e) {
                throw new ParseException(e);
            }
        }
        if (serviceDescriptor != null) {
            this.errorReceiver.warning(new SAXParseException(WsdlMessages.TRY_WITH_MEX(ex.getMessage()), null, ex));
            return this.parseMetadata(systemId, serviceDescriptor);
        }
        this.errorReceiver.error(null, WsdlMessages.PARSING_UNABLE_TO_GET_METADATA(ex.getMessage(), WscompileMessages.WSIMPORT_NO_WSDL(systemId)), ex);
        return null;
    }

    private Element parseMetadata(@NotNull String systemId, @NotNull ServiceDescriptor serviceDescriptor) {
        Node n;
        List mexWsdls = serviceDescriptor.getWSDLs();
        List mexSchemas = serviceDescriptor.getSchemas();
        Document root = null;
        for (Source src : mexWsdls) {
            NodeList nl;
            Document doc;
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            if (n.getNodeType() == 1 && n.getOwnerDocument() == null) {
                doc = DOMUtil.createDom();
                doc.importNode(n, true);
            } else {
                doc = n.getOwnerDocument();
            }
            if (root == null && (nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "service")).getLength() > 0) {
                root = doc;
                this.rootWSDL = src.getSystemId();
            }
            nl = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element imp = (Element)nl.item(i);
                String loc = imp.getAttribute("location");
                if (loc == null || this.externalReferences.contains(loc)) continue;
                this.externalReferences.add(loc);
            }
            if (this.core.keySet().contains(systemId)) {
                this.core.remove(systemId);
            }
            this.core.put(src.getSystemId(), doc);
            this.resolvedCache.put(systemId, doc.getDocumentURI());
            this.isMexMetadata = true;
        }
        for (Source src : mexSchemas) {
            if (!(src instanceof DOMSource)) continue;
            n = ((DOMSource)src).getNode();
            Element e = n.getNodeType() == 1 ? (Element)n : DOMUtil.getFirstElementChild((Node)n);
            this.inlinedSchemaElements.add(e);
        }
        return root.getDocumentElement();
    }

    private static class HttpClientVerifier
    implements HostnameVerifier {
        private HttpClientVerifier() {
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    }

    public static class WSEntityResolver
    implements EntityResolver {
        WsimportOptions options;
        ErrorReceiver errorReceiver;

        public WSEntityResolver(WsimportOptions options, ErrorReceiver errReceiver) {
            this.options = options;
            this.errorReceiver = errReceiver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            InputSource inputSource = null;
            if (this.options.entityResolver != null) {
                inputSource = this.options.entityResolver.resolveEntity(null, systemId);
            }
            if (inputSource == null) {
                boolean redirect;
                inputSource = new InputSource(systemId);
                InputStream is = null;
                int redirects = 0;
                URL url = JAXWSUtils.getFileOrURL((String)inputSource.getSystemId());
                URLConnection conn = url.openConnection();
                do {
                    URL newurl;
                    List<String> seeOther;
                    HttpURLConnection httpConn;
                    int code;
                    if (conn instanceof HttpsURLConnection && this.options.disableSSLHostnameVerification) {
                        ((HttpsURLConnection)conn).setHostnameVerifier(new HttpClientVerifier());
                    }
                    redirect = false;
                    if (conn instanceof HttpURLConnection) {
                        ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
                    }
                    try {
                        is = conn.getInputStream();
                    }
                    catch (IOException e) {
                        HttpURLConnection httpConn2;
                        int code2;
                        if (conn instanceof HttpURLConnection && (code2 = (httpConn2 = (HttpURLConnection)conn).getResponseCode()) == 401) {
                            this.errorReceiver.error(new SAXParseException(WscompileMessages.WSIMPORT_AUTH_INFO_NEEDED(e.getMessage(), systemId, DefaultAuthenticator.defaultAuthfile), null, e));
                            throw new AbortException();
                        }
                        throw e;
                    }
                    if (!(conn instanceof HttpURLConnection) || (code = (httpConn = (HttpURLConnection)conn).getResponseCode()) != 302 && code != 303 || (seeOther = httpConn.getHeaderFields().get("Location")) == null || seeOther.size() <= 0 || (newurl = new URL(url, seeOther.get(0))).equals(url)) continue;
                    this.errorReceiver.info(new SAXParseException(WscompileMessages.WSIMPORT_HTTP_REDIRECT(code, seeOther.get(0)), null));
                    url = newurl;
                    httpConn.disconnect();
                    if (redirects >= 5) {
                        this.errorReceiver.error(new SAXParseException(WscompileMessages.WSIMPORT_MAX_REDIRECT_ATTEMPT(), null));
                        throw new AbortException();
                    }
                    conn = url.openConnection();
                    inputSource.setSystemId(url.toExternalForm());
                    ++redirects;
                    redirect = true;
                } while (redirect);
                inputSource.setByteStream(is);
            }
            return inputSource;
        }
    }
}

