/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.util;

import com.sun.istack.NotNull;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.WsimportListener;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.tools.ws.wsdl.parser.MetadataFinder;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.streaming.SourceReaderFactory;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import com.sun.xml.ws.wsdl.writer.DocumentLocationResolver;
import com.sun.xml.ws.wsdl.writer.WSDLPatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLFetcher {
    private WsimportOptions options;
    private WsimportListener listener;
    private static String WSDL_PATH = "META-INF/wsdl";
    private static String WSDL_FILE_EXTENSION = ".wsdl";
    private static String SCHEMA_FILE_EXTENSION = ".xsd";

    public WSDLFetcher(WsimportOptions options, WsimportListener listener) {
        this.options = options;
        this.listener = listener;
    }

    public String fetchWsdls(MetadataFinder forest) throws IOException, XMLStreamException {
        String rootWsdl = null;
        Iterator<String> i$ = forest.getRootDocuments().iterator();
        while (i$.hasNext()) {
            String root;
            rootWsdl = root = i$.next();
        }
        Set<String> externalRefs = forest.getExternalReferences();
        Map<String, String> documentMap = this.createDocumentMap(forest, this.getWSDLDownloadDir(), rootWsdl, externalRefs);
        String rootWsdlName = this.fetchFile(rootWsdl, forest, documentMap, this.getWSDLDownloadDir());
        for (String reference : forest.getExternalReferences()) {
            this.fetchFile(reference, forest, documentMap, this.getWSDLDownloadDir());
        }
        return WSDL_PATH + "/" + rootWsdlName;
    }

    private String fetchFile(String doc, DOMForest forest, Map<String, String> documentMap, File destDir) throws IOException, XMLStreamException {
        DocumentLocationResolver docLocator = this.createDocResolver(doc, forest, documentMap);
        WSDLPatcher wsdlPatcher = new WSDLPatcher(new PortAddressResolver(){

            public String getAddressFor(@NotNull QName serviceName, @NotNull String portName) {
                return null;
            }
        }, docLocator);
        XMLStreamReader xsr = SourceReaderFactory.createSourceReader((Source)new DOMSource(forest.get(doc)), (boolean)false);
        XMLOutputFactory writerfactory = XMLOutputFactory.newInstance();
        String resolvedRootWsdl = docLocator.getLocationFor(null, doc);
        File outFile = new File(destDir, resolvedRootWsdl);
        FileOutputStream os = new FileOutputStream(outFile);
        if (this.options.verbose) {
            this.listener.message(WscompileMessages.WSIMPORT_DOCUMENT_DOWNLOAD(doc, outFile));
        }
        XMLStreamWriter xsw = writerfactory.createXMLStreamWriter(os);
        IndentingXMLStreamWriter indentingWriter = new IndentingXMLStreamWriter(xsw);
        wsdlPatcher.bridge(xsr, (XMLStreamWriter)indentingWriter);
        xsr.close();
        xsw.close();
        ((OutputStream)os).close();
        this.options.addGeneratedFile(outFile);
        return resolvedRootWsdl;
    }

    private Map<String, String> createDocumentMap(MetadataFinder forest, File baseDir, String rootWsdl, Set<String> externalReferences) {
        String rootWsdlName;
        HashMap<String, String> map = new HashMap<String, String>();
        String rootWsdlFileName = rootWsdl;
        int slashIndex = rootWsdl.lastIndexOf("/");
        if (slashIndex >= 0) {
            rootWsdlFileName = rootWsdl.substring(slashIndex + 1);
        }
        if (!rootWsdlFileName.endsWith(WSDL_FILE_EXTENSION)) {
            Document rootWsdlDoc = forest.get(rootWsdl);
            NodeList serviceNodes = rootWsdlDoc.getElementsByTagNameNS(WSDLConstants.QNAME_SERVICE.getNamespaceURI(), WSDLConstants.QNAME_SERVICE.getLocalPart());
            if (serviceNodes.getLength() == 0) {
                rootWsdlName = "Service";
            } else {
                String serviceName;
                Node serviceNode = serviceNodes.item(0);
                rootWsdlName = serviceName = ((Element)serviceNode).getAttribute("name");
            }
            rootWsdlFileName = rootWsdlName + WSDL_FILE_EXTENSION;
        } else {
            rootWsdlName = rootWsdlFileName.substring(0, rootWsdlFileName.length() - 5);
        }
        map.put(rootWsdl, this.sanitize(rootWsdlFileName));
        int i = 1;
        for (String ref : externalReferences) {
            Document refDoc = forest.get(ref);
            Element rootEl = refDoc.getDocumentElement();
            String fileName = null;
            int index = ref.lastIndexOf("/");
            if (index >= 0) {
                fileName = ref.substring(index + 1);
            }
            String fileExtn = rootEl.getLocalName().equals(WSDLConstants.QNAME_DEFINITIONS.getLocalPart()) && rootEl.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/") ? WSDL_FILE_EXTENSION : (rootEl.getLocalName().equals(WSDLConstants.QNAME_SCHEMA.getLocalPart()) && rootEl.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") ? SCHEMA_FILE_EXTENSION : ".xml");
            if (fileName != null && (fileName.endsWith(WSDL_FILE_EXTENSION) || fileName.endsWith(SCHEMA_FILE_EXTENSION))) {
                map.put(ref, rootWsdlName + "_" + fileName);
                continue;
            }
            map.put(ref, rootWsdlName + "_metadata" + i++ + fileExtn);
        }
        return map;
    }

    private DocumentLocationResolver createDocResolver(final String baseWsdl, final DOMForest forest, final Map<String, String> documentMap) {
        return new DocumentLocationResolver(){

            public String getLocationFor(String namespaceURI, String systemId) {
                try {
                    URL reference = new URL(new URL(baseWsdl), systemId);
                    systemId = reference.toExternalForm();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                if (documentMap.get(systemId) != null) {
                    return (String)documentMap.get(systemId);
                }
                String parsedEntity = forest.getReferencedEntityMap().get(systemId);
                return (String)documentMap.get(parsedEntity);
            }
        };
    }

    private String sanitize(String fileName) {
        fileName = fileName.replace('?', '.');
        StringBuffer sb = new StringBuffer(fileName);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    private File getWSDLDownloadDir() {
        File wsdlDir = new File(this.options.destDir, WSDL_PATH);
        wsdlDir.mkdirs();
        return wsdlDir;
    }
}

