/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.document;

import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.ws.wsdl.document.BindingFault;
import com.sun.tools.ws.wsdl.document.BindingInput;
import com.sun.tools.ws.wsdl.document.BindingOutput;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.OperationStyle;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.EntityAction;
import com.sun.tools.ws.wsdl.framework.ExtensibilityHelper;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingOperation
extends Entity
implements TWSDLExtensible {
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private BindingInput _input;
    private BindingOutput _output;
    private List<BindingFault> _faults = new ArrayList<BindingFault>();
    private OperationStyle _style;
    private String _uniqueKey;
    private TWSDLExtensible parent;

    public BindingOperation() {
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getUniqueKey() {
        if (this._uniqueKey == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this._name);
            sb.append(' ');
            if (this._input != null) {
                sb.append(this._input.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Request");
                } else if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Response");
                }
            }
            sb.append(' ');
            if (this._output != null) {
                sb.append(this._output.getName());
            } else {
                sb.append(this._name);
                if (this._style == OperationStyle.SOLICIT_RESPONSE) {
                    sb.append("Solicit");
                } else if (this._style == OperationStyle.REQUEST_RESPONSE) {
                    sb.append("Response");
                }
            }
            this._uniqueKey = sb.toString();
        }
        return this._uniqueKey;
    }

    public OperationStyle getStyle() {
        return this._style;
    }

    public void setStyle(OperationStyle s) {
        this._style = s;
    }

    public BindingInput getInput() {
        return this._input;
    }

    public void setInput(BindingInput i) {
        this._input = i;
    }

    public BindingOutput getOutput() {
        return this._output;
    }

    public void setOutput(BindingOutput o) {
        this._output = o;
    }

    public void addFault(BindingFault f) {
        this._faults.add(f);
    }

    public Iterable<BindingFault> faults() {
        return this._faults;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_OPERATION;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public String getNameValue() {
        return this.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.parent.getNamespaceURI();
    }

    @Override
    public QName getWSDLElementName() {
        return this.getElementName();
    }

    @Override
    public void addExtension(TWSDLExtension e) {
        this._helper.addExtension(e);
    }

    public Iterable<TWSDLExtension> extensions() {
        return this._helper.extensions();
    }

    @Override
    public TWSDLExtensible getParent() {
        return this.parent;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        if (this._input != null) {
            action.perform(this._input);
        }
        if (this._output != null) {
            action.perform(this._output);
        }
        for (BindingFault _fault : this._faults) {
            action.perform(_fault);
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        this._helper.accept(visitor);
        if (this._input != null) {
            this._input.accept(visitor);
        }
        if (this._output != null) {
            this._output.accept(visitor);
        }
        for (BindingFault _fault : this._faults) {
            _fault.accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this._name == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
        if (this._style == null) {
            this.failValidation("validation.missingRequiredProperty", "style");
        }
        if (this._style == OperationStyle.ONE_WAY) {
            if (this._input == null) {
                this.failValidation("validation.missingRequiredSubEntity", "input");
            }
            if (this._output != null) {
                this.failValidation("validation.invalidSubEntity", "output");
            }
            if (this._faults != null && this._faults.size() != 0) {
                this.failValidation("validation.invalidSubEntity", "fault");
            }
        }
    }

    public void setParent(TWSDLExtensible parent) {
        this.parent = parent;
    }
}

