/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.xml.ws.server.ServerRtException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

final class ServerMgr {
    private static final ServerMgr serverMgr = new ServerMgr();
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");
    private final Map<InetSocketAddress, ServerState> servers = new HashMap<InetSocketAddress, ServerState>();

    private ServerMgr() {
    }

    public static ServerMgr getInstance() {
        return serverMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpContext createContext(String address) {
        try {
            ServerState state;
            URL url = new URL(address);
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            InetSocketAddress inetAddress = new InetSocketAddress(url.getHost(), port);
            Map<InetSocketAddress, ServerState> map = this.servers;
            synchronized (map) {
                state = this.servers.get(inetAddress);
                if (state == null) {
                    logger.fine("Creating new HTTP Server at " + inetAddress);
                    HttpServer server = HttpServer.create(inetAddress, 5);
                    server.setExecutor(Executors.newFixedThreadPool(5));
                    logger.fine("Creating HTTP Context at = " + url.getPath());
                    HttpContext context = server.createContext(url.getPath());
                    server.start();
                    logger.fine("HTTP server started = " + inetAddress);
                    state = new ServerState(server);
                    this.servers.put(inetAddress, state);
                    return context;
                }
            }
            HttpServer server = state.getServer();
            logger.fine("Creating HTTP Context at = " + url.getPath());
            HttpContext context = server.createContext(url.getPath());
            state.oneMoreContext();
            return context;
        }
        catch (Exception e) {
            throw new ServerRtException("server.rt.err", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContext(HttpContext context) {
        InetSocketAddress inetAddress = context.getServer().getAddress();
        Map<InetSocketAddress, ServerState> map = this.servers;
        synchronized (map) {
            ServerState state = this.servers.get(inetAddress);
            int instances = state.noOfContexts();
            if (instances < 2) {
                ((ExecutorService)state.getServer().getExecutor()).shutdown();
                state.getServer().stop(0);
                this.servers.remove(inetAddress);
            } else {
                state.getServer().removeContext(context);
                state.oneLessContext();
            }
        }
    }

    private static final class ServerState {
        private final HttpServer server;
        private int instances;

        ServerState(HttpServer server) {
            this.server = server;
            this.instances = 1;
        }

        public HttpServer getServer() {
            return this.server;
        }

        public void oneMoreContext() {
            ++this.instances;
        }

        public void oneLessContext() {
            --this.instances;
        }

        public int noOfContexts() {
            return this.instances;
        }
    }
}

