/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.ExceptionHasMessage;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.server.AbstractServerAsyncTransport;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAdapter
extends Adapter<HttpToolkit> {
    public final Map<String, SDDocument> wsdls;
    public final Map<SDDocument, String> revWsdls;
    public final HttpAdapterList<? extends HttpAdapter> owner;
    private static final boolean dump;
    private static final Logger LOGGER;

    public static HttpAdapter createAlone(WSEndpoint endpoint) {
        return new DummyList().createAdapter("", "", endpoint);
    }

    protected HttpAdapter(WSEndpoint endpoint, HttpAdapterList<? extends HttpAdapter> owner) {
        super(endpoint);
        this.owner = owner;
        ServiceDefinition sdef = this.endpoint.getServiceDefinition();
        if (sdef == null) {
            this.wsdls = Collections.emptyMap();
            this.revWsdls = Collections.emptyMap();
        } else {
            this.wsdls = new HashMap<String, SDDocument>();
            TreeMap<String, SDDocument> systemIds = new TreeMap<String, SDDocument>();
            for (SDDocument sdd : sdef) {
                if (sdd == sdef.getPrimary()) {
                    this.wsdls.put("wsdl", sdd);
                    this.wsdls.put("WSDL", sdd);
                    continue;
                }
                systemIds.put(sdd.getURL().toString(), sdd);
            }
            int wsdlnum = 1;
            int xsdnum = 1;
            for (Map.Entry entry : systemIds.entrySet()) {
                SDDocument sdd = (SDDocument)entry.getValue();
                if (sdd.isWSDL()) {
                    this.wsdls.put("wsdl=" + wsdlnum++, sdd);
                }
                if (!sdd.isSchema()) continue;
                this.wsdls.put("xsd=" + xsdnum++, sdd);
            }
            this.revWsdls = new HashMap<SDDocument, String>();
            for (Map.Entry<Object, Object> entry : this.wsdls.entrySet()) {
                this.revWsdls.put((SDDocument)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    @Override
    protected HttpToolkit createToolkit() {
        return new HttpToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull WSHTTPConnection connection) throws IOException {
        HttpToolkit tk = (HttpToolkit)this.pool.take();
        try {
            tk.handle(connection);
        }
        finally {
            this.pool.recycle(tk);
        }
    }

    private Packet decodePacket(@NotNull WSHTTPConnection con, @NotNull Codec codec) throws IOException {
        String ct = con.getRequestHeader("Content-Type");
        InputStream in = con.getInput();
        Packet packet = new Packet();
        packet.acceptableMimeTypes = con.getRequestHeader("Accept");
        packet.addSatellite(con);
        packet.transportBackChannel = new Oneway(con);
        packet.webServiceContextDelegate = con.getWebServiceContextDelegate();
        if (dump) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            buf.write(in);
            this.dump(buf, "HTTP request", con.getRequestHeaders());
            in = buf.newInputStream();
        }
        codec.decode(in, ct, packet);
        return packet;
    }

    private void encodePacket(@NotNull Packet packet, @NotNull WSHTTPConnection con, @NotNull Codec codec) throws IOException {
        if (con.isClosed()) {
            return;
        }
        Message responseMessage = packet.getMessage();
        if (responseMessage == null) {
            if (!con.isClosed()) {
                con.setStatus(202);
                try {
                    con.getOutput().close();
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        } else {
            ContentType contentType;
            if (con.getStatus() == 0) {
                con.setStatus(responseMessage.isFault() ? 500 : 200);
            }
            if ((contentType = codec.getStaticContentType(packet)) != null) {
                con.setContentTypeResponseHeader(contentType.getContentType());
                OutputStream os = con.getOutput();
                if (dump) {
                    ByteArrayBuffer buf = new ByteArrayBuffer();
                    codec.encode(packet, buf);
                    this.dump(buf, "HTTP response " + con.getStatus(), con.getResponseHeaders());
                    buf.writeTo(os);
                } else {
                    codec.encode(packet, os);
                }
                os.close();
            } else {
                ByteArrayBuffer buf = new ByteArrayBuffer();
                contentType = codec.encode(packet, buf);
                con.setContentTypeResponseHeader(contentType.getContentType());
                if (dump) {
                    this.dump(buf, "HTTP response " + con.getStatus(), con.getResponseHeaders());
                }
                OutputStream os = con.getOutput();
                buf.writeTo(os);
                os.close();
            }
        }
    }

    public void invokeAsync(final WSHTTPConnection con) throws IOException {
        Packet request;
        final HttpToolkit tk = (HttpToolkit)this.pool.take();
        try {
            request = this.decodePacket(con, tk.codec);
        }
        catch (ExceptionHasMessage e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
            Packet response = new Packet();
            response.setMessage(e.getFaultMessage());
            this.encodePacket(response, con, tk.codec);
            this.pool.recycle(tk);
            con.close();
            return;
        }
        this.endpoint.schedule(request, new WSEndpoint.CompletionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(@NotNull Packet response) {
                try {
                    try {
                        HttpAdapter.this.encodePacket(response, con, tk.codec);
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                    }
                    HttpAdapter.this.pool.recycle(tk);
                }
                finally {
                    con.close();
                }
            }
        });
    }

    public final boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    public void publishWSDL(WSHTTPConnection con, String baseAddress, String queryString) throws IOException {
        InputStream in = con.getInput();
        while (in.read() != -1) {
        }
        in.close();
        SDDocument doc = this.wsdls.get(queryString);
        if (doc == null) {
            this.writeNotFoundErrorPage(con, "Invalid Request");
            return;
        }
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/xml");
        OutputStream os = con.getOutput();
        PortAddressResolver portAddressResolver = this.owner.createPortAddressResolver(baseAddress);
        final String address = portAddressResolver.getAddressFor(this.endpoint.getPortName().getLocalPart());
        assert (address != null);
        DocumentAddressResolver resolver = new DocumentAddressResolver(){

            public String getRelativeAddressFor(@NotNull SDDocument current, @NotNull SDDocument referenced) {
                assert (HttpAdapter.this.revWsdls.containsKey(referenced));
                return address + '?' + HttpAdapter.this.revWsdls.get(referenced);
            }
        };
        doc.writeTo(portAddressResolver, resolver, os);
        os.close();
    }

    private void writeNotFoundErrorPage(WSHTTPConnection con, String message) throws IOException {
        con.setStatus(404);
        con.setContentTypeResponseHeader("text/html; charset=UTF-8");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8"));
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_NOT_FOUND(message));
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void writeInternalServerError(WSHTTPConnection con) throws IOException {
        con.setStatus(500);
        con.getOutput().close();
    }

    private void dump(ByteArrayBuffer buf, String caption, Map<String, List<String>> headers) throws IOException {
        System.out.println("---[" + caption + "]---");
        if (headers != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if (header.getValue().isEmpty()) {
                    System.out.println(header.getValue());
                    continue;
                }
                for (String value : header.getValue()) {
                    System.out.println(header.getKey() + ": " + value);
                }
            }
        }
        buf.writeTo(System.out);
        System.out.println("--------------------");
    }

    static {
        boolean b;
        try {
            b = Boolean.getBoolean(HttpAdapter.class.getName() + ".dump");
        }
        catch (Throwable t) {
            b = false;
        }
        dump = b;
        LOGGER = Logger.getLogger(HttpAdapter.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyList
    extends HttpAdapterList<HttpAdapter> {
        private DummyList() {
        }

        @Override
        protected HttpAdapter createHttpAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
            return new HttpAdapter(endpoint, this);
        }
    }

    final class HttpToolkit
    extends Adapter.Toolkit {
        HttpToolkit() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(WSHTTPConnection con) throws IOException {
            try {
                Packet packet;
                try {
                    packet = HttpAdapter.this.decodePacket(con, this.codec);
                }
                catch (ExceptionHasMessage e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)((Object)e));
                    packet = new Packet();
                    packet.setMessage(e.getFaultMessage());
                }
                if (!packet.getMessage().isFault()) {
                    try {
                        packet = this.head.process(packet, con.getWebServiceContextDelegate(), packet.transportBackChannel);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e.getMessage(), e);
                        if (!con.isClosed()) {
                            HttpAdapter.this.writeInternalServerError(con);
                        }
                        if (!con.isClosed()) {
                            con.close();
                        }
                        return;
                    }
                }
                HttpAdapter.this.encodePacket(packet, con, this.codec);
            }
            finally {
                if (!con.isClosed()) {
                    con.close();
                }
            }
        }
    }

    final class Oneway
    implements TransportBackChannel {
        WSHTTPConnection con;

        Oneway(WSHTTPConnection con) {
            this.con = con;
        }

        public void close() {
            if (!this.con.isClosed()) {
                this.con.setStatus(202);
                try {
                    this.con.getOutput().close();
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
                this.con.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AsyncTransport
    extends AbstractServerAsyncTransport<WSHTTPConnection> {
        public AsyncTransport() {
            super(HttpAdapter.this.endpoint);
        }

        public void handleAsync(WSHTTPConnection con) throws IOException {
            super.handle(con);
        }

        @Override
        protected void encodePacket(WSHTTPConnection con, @NotNull Packet packet, @NotNull Codec codec) throws IOException {
            HttpAdapter.this.encodePacket(packet, con, codec);
        }

        @Override
        @Nullable
        protected String getAcceptableMimeTypes(WSHTTPConnection con) {
            return null;
        }

        @Override
        @Nullable
        protected TransportBackChannel getTransportBackChannel(WSHTTPConnection con) {
            return new Oneway(con);
        }

        @Override
        @NotNull
        protected PropertySet getPropertySet(WSHTTPConnection con) {
            return con;
        }

        @Override
        @NotNull
        protected WebServiceContextDelegate getWebServiceContextDelegate(WSHTTPConnection con) {
            return con.getWebServiceContextDelegate();
        }
    }
}

