/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.server.SDDocumentImpl;
import com.sun.xml.ws.server.ServiceDefinitionImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.util.xml.XMLStreamReaderToXMLStreamWriter;
import com.sun.xml.ws.wsdl.parser.WSDLConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WSDLPatcher
extends XMLStreamReaderToXMLStreamWriter {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.wsdl.patcher");
    private final WSEndpointImpl<?> endpoint;
    private final SDDocumentImpl current;
    private final DocumentAddressResolver resolver;
    private final PortAddressResolver portAddressResolver;
    private String targetNamespace;
    private QName serviceName;
    private QName portName;

    public WSDLPatcher(WSEndpointImpl<?> endpoint, SDDocumentImpl current, PortAddressResolver portAddressResolver, DocumentAddressResolver resolver) {
        this.endpoint = endpoint;
        this.current = current;
        this.portAddressResolver = portAddressResolver;
        this.resolver = resolver;
    }

    @Override
    protected void handleAttribute(int i) throws XMLStreamException {
        String value;
        QName name = this.in.getName();
        String attLocalName = this.in.getAttributeLocalName(i);
        if (name.equals(SCHEMA_INCLUDE_QNAME) && attLocalName.equals("schemaLocation") || name.equals(SCHEMA_IMPORT_QNAME) && attLocalName.equals("schemaLocation") || name.equals(WSDLConstants.QNAME_IMPORT) && attLocalName.equals("location")) {
            String relPath = this.in.getAttributeValue(i);
            String actualPath = this.getPatchedImportLocation(relPath);
            if (actualPath == null) {
                return;
            }
            logger.fine("Fixing the relative location:" + relPath + " with absolute location:" + actualPath);
            this.writeAttribute(i, actualPath);
            return;
        }
        if ((name.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || name.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) && attLocalName.equals("location") && (value = this.getAddressLocation()) != null) {
            logger.fine("Fixing service:" + this.serviceName + " port:" + this.portName + " address with " + value);
            this.writeAttribute(i, value);
            return;
        }
        super.handleAttribute(i);
    }

    private void writeAttribute(int i, String value) throws XMLStreamException {
        String nsUri = this.in.getAttributeNamespace(i);
        if (nsUri != null) {
            this.out.writeAttribute(this.in.getAttributePrefix(i), nsUri, this.in.getAttributeLocalName(i), value);
        } else {
            this.out.writeAttribute(this.in.getAttributeLocalName(i), value);
        }
    }

    @Override
    protected void handleStartElement() throws XMLStreamException {
        String value;
        QName name = this.in.getName();
        if (name.equals(WSDLConstants.QNAME_DEFINITIONS)) {
            String value2 = this.in.getAttributeValue(null, "targetNamespace");
            if (value2 != null) {
                this.targetNamespace = value2;
            }
        } else if (name.equals(WSDLConstants.QNAME_SERVICE)) {
            String value3 = this.in.getAttributeValue(null, "name");
            if (value3 != null) {
                this.serviceName = new QName(this.targetNamespace, value3);
            }
        } else if (name.equals(WSDLConstants.QNAME_PORT) && (value = this.in.getAttributeValue(null, "name")) != null) {
            this.portName = new QName(this.targetNamespace, value);
        }
        super.handleStartElement();
    }

    @Nullable
    private String getPatchedImportLocation(String relPath) {
        try {
            ServiceDefinitionImpl def = this.endpoint.getServiceDefinition();
            assert (def != null);
            URL ref = new URL(this.current.getURL(), relPath);
            SDDocument refDoc = def.getBySystemId(ref);
            if (refDoc == null) {
                return relPath;
            }
            return this.resolver.getRelativeAddressFor(this.current, refDoc);
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private String getAddressLocation() {
        WSDLPort port = this.endpoint.getPort();
        if (port.getOwner().getName().equals(this.serviceName)) {
            return this.portAddressResolver == null ? null : this.portAddressResolver.getAddressFor(this.portName.getLocalPart());
        }
        return null;
    }
}

