/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.fault;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.fault.DetailType;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.w3c.dom.Node;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"faultcode", "faultstring", "faultactor", "detail"})
@XmlRootElement(name="Fault", namespace="http://schemas.xmlsoap.org/soap/envelope/")
class SOAP11Fault
extends SOAPFaultBuilder {
    @XmlElement(namespace="")
    private QName faultcode;
    @XmlElement(namespace="")
    private String faultstring;
    @XmlElement(namespace="")
    private String faultactor;
    @XmlElement(namespace="")
    private DetailType detail;

    SOAP11Fault() {
    }

    SOAP11Fault(QName code, String reason, String actor, Object detailObject) {
        this.faultcode = code;
        this.faultstring = reason;
        this.faultactor = actor;
        if (detailObject != null) {
            this.detail = new DetailType(detailObject);
        }
    }

    SOAP11Fault(SOAPFault fault) {
        this.faultcode = fault.getFaultCodeAsQName();
        this.faultstring = fault.getFaultString();
        this.faultactor = fault.getFaultActor();
        if (fault.getDetail() != null) {
            this.detail = new DetailType(fault.getDetail());
        }
    }

    QName getFaultcode() {
        return this.faultcode;
    }

    void setFaultcode(QName faultcode) {
        this.faultcode = faultcode;
    }

    String getFaultString() {
        return this.faultstring;
    }

    void setFaultstring(String faultstring) {
        this.faultstring = faultstring;
    }

    String getFaultactor() {
        return this.faultactor;
    }

    void setFaultactor(String faultactor) {
        this.faultactor = faultactor;
    }

    DetailType getDetail() {
        return this.detail;
    }

    void setDetail(DetailType detail) {
        this.detail = detail;
    }

    protected Throwable getProtocolException() {
        try {
            SOAPFault fault = SOAPVersion.SOAP_11.saajSoapFactory.createFault(this.faultstring, this.faultcode);
            if (this.detail != null && this.detail.getDetails() != null && this.detail.getDetails().size() > 0 && this.detail.getDetails().get(0) instanceof Node) {
                Node n = fault.getOwnerDocument().importNode((Node)this.detail.getDetails().get(0), true);
                Detail d = fault.addDetail();
                d.appendChild(n);
            }
            fault.setFaultActor(this.faultactor);
            return new SOAPFaultException(fault);
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

