/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.client.WSBindingProvider;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.util.Pool;
import com.sun.xml.ws.util.RuntimeVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stub
implements WSBindingProvider,
ResponseContextReceiver,
Closeable {
    private Pool<Tube> tubes;
    private final Engine engine;
    protected final WSServiceDelegate owner;
    @Nullable
    protected final WSEndpointReference endpointReference;
    protected final BindingImpl binding;
    public final RequestContext requestContext = new RequestContext();
    private ResponseContext responseContext;
    @Nullable
    protected final WSDLPort wsdlPort;
    @Nullable
    private volatile Header[] userOutboundHeaders;

    protected Stub(WSServiceDelegate owner, Tube master, BindingImpl binding, WSDLPort wsdlPort, EndpointAddress defaultEndPointAddress, @Nullable WSEndpointReference epr) {
        this.owner = owner;
        this.tubes = new Pool.TubePool(master);
        this.wsdlPort = wsdlPort;
        this.binding = binding;
        this.requestContext.setEndpointAddress(defaultEndPointAddress);
        this.engine = new Engine();
        this.endpointReference = epr;
    }

    @NotNull
    protected abstract QName getPortName();

    @NotNull
    protected final QName getServiceName() {
        return this.owner.getServiceName();
    }

    public final Executor getExecutor() {
        return this.owner.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Packet process(Packet packet, RequestContext requestContext, ResponseContextReceiver receiver) {
        Packet reply;
        Pool<Tube> pool;
        Header[] hl;
        packet.proxy = this;
        packet.handlerConfig = this.binding.getHandlerConfig();
        requestContext.fill(packet);
        if (AddressingVersion.isEnabled(this.binding) && this.endpointReference != null) {
            this.endpointReference.addReferenceParameters(packet.getMessage().getHeaders());
        }
        if ((hl = this.userOutboundHeaders) != null) {
            packet.getMessage().getHeaders().addAll(hl);
        }
        if ((pool = this.tubes) == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        Tube tube = pool.take();
        try {
            reply = fiber.runSync(tube, packet);
        }
        finally {
            pool.recycle(tube);
        }
        receiver.setResponseContext(new ResponseContext(reply));
        return reply;
    }

    protected final void processAsync(Packet request, RequestContext requestContext, final Fiber.CompletionCallback completionCallback) {
        Pool<Tube> pool;
        request.proxy = this;
        request.handlerConfig = this.binding.getHandlerConfig();
        requestContext.fill(request);
        if (AddressingVersion.isEnabled(this.binding) && this.endpointReference != null) {
            this.endpointReference.addReferenceParameters(request.getMessage().getHeaders());
        }
        if ((pool = this.tubes) == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        final Tube tube = pool.take();
        fiber.start(tube, request, new Fiber.CompletionCallback(){

            public void onCompletion(@NotNull Packet response) {
                pool.recycle(tube);
                completionCallback.onCompletion(response);
            }

            public void onCompletion(@NotNull Throwable error) {
                completionCallback.onCompletion(error);
            }
        });
    }

    @Override
    public void close() {
        if (this.tubes != null) {
            Tube p = this.tubes.take();
            this.tubes = null;
            p.preDestroy();
        }
    }

    public final WSBinding getBinding() {
        return this.binding;
    }

    public final Map<String, Object> getRequestContext() {
        return this.requestContext.getMapView();
    }

    public final ResponseContext getResponseContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext rc) {
        this.responseContext = rc;
    }

    public String toString() {
        return RuntimeVersion.VERSION + ": Stub for " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public final W3CEndpointReference getEndpointReference() {
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException("BindingProvider.getEndpointReference() not supported with XML/HTTP Binding");
        }
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    public final <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException("BindingProvider.getEndpointReference(Class<T> class) not supported with XML/HTTP Binding");
        }
        if (this.endpointReference != null) {
            return this.endpointReference.toSpec(clazz);
        }
        String eprAddress = this.requestContext.getEndpointAddress().toString();
        QName portTypeName = null;
        String wsdlAddress = null;
        if (this.wsdlPort != null) {
            portTypeName = this.wsdlPort.getBinding().getPortTypeName();
            wsdlAddress = eprAddress + "?wsdl";
        }
        return new WSEndpointReference(AddressingVersion.fromSpecClass(clazz), eprAddress, this.getServiceName(), this.getPortName(), portTypeName, null, wsdlAddress, null).toSpec(clazz);
    }

    @Override
    public final void setOutboundHeaders(List<Header> headers) {
        if (headers == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header h : headers) {
                if (h != null) continue;
                throw new IllegalArgumentException();
            }
            this.userOutboundHeaders = headers.toArray(new Header[headers.size()]);
        }
    }

    @Override
    public final void setOutboundHeaders(Header ... headers) {
        if (headers == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header h : headers) {
                if (h != null) continue;
                throw new IllegalArgumentException();
            }
            Header[] hl = new Header[headers.length];
            System.arraycopy(headers, 0, hl, 0, headers.length);
            this.userOutboundHeaders = hl;
        }
    }

    @Override
    public final List<Header> getInboundHeaders() {
        return Collections.unmodifiableList((HeaderList)this.responseContext.get("com.sun.xml.ws.api.message.HeaderList"));
    }
}

