/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.SDDocumentFilter;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.server.SDDocumentImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.wsdl.SDDocumentResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServiceDefinitionImpl
implements ServiceDefinition,
SDDocumentResolver {
    private final List<SDDocumentImpl> docs;
    private final Map<String, SDDocumentImpl> bySystemId;
    @NotNull
    private final SDDocumentImpl primaryWsdl;
    WSEndpointImpl<?> owner;
    final List<SDDocumentFilter> filters = new ArrayList<SDDocumentFilter>();

    public ServiceDefinitionImpl(List<SDDocumentImpl> docs, @NotNull SDDocumentImpl primaryWsdl) {
        assert (docs.contains(primaryWsdl));
        this.docs = docs;
        this.primaryWsdl = primaryWsdl;
        this.bySystemId = new HashMap<String, SDDocumentImpl>(docs.size());
        for (SDDocumentImpl doc : docs) {
            this.bySystemId.put(doc.getURL().toExternalForm(), doc);
            doc.setFilters(this.filters);
            doc.setResolver(this);
        }
    }

    void setOwner(WSEndpointImpl<?> owner) {
        assert (owner != null && this.owner == null);
        this.owner = owner;
    }

    @Override
    @NotNull
    public SDDocument getPrimary() {
        return this.primaryWsdl;
    }

    @Override
    public void addFilter(SDDocumentFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public Iterator<SDDocument> iterator() {
        return this.docs.iterator();
    }

    @Override
    public SDDocument resolve(String systemId) {
        return this.bySystemId.get(systemId);
    }
}

