/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.servlet.ServletConnectionImpl;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServletAdapter
extends HttpAdapter {
    final String name;
    final String urlPattern;

    protected ServletAdapter(String name, String urlPattern, WSEndpoint endpoint, HttpAdapterList<ServletAdapter> owner) {
        super(endpoint, owner);
        this.name = name;
        this.urlPattern = urlPattern;
    }

    public String getName() {
        return this.name;
    }

    public String getValidPath() {
        if (this.urlPattern.endsWith("/*")) {
            return this.urlPattern.substring(0, this.urlPattern.length() - 2);
        }
        return this.urlPattern;
    }

    public QName getPortName() {
        WSDLPort port = this.getEndpoint().getPort();
        if (port == null) {
            return null;
        }
        return port.getName();
    }

    public void handle(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletConnectionImpl connection = new ServletConnectionImpl(this, context, request, response);
        super.handle(connection);
    }

    public void publishWSDL(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletConnectionImpl con = new ServletConnectionImpl(this, context, request, response);
        super.publishWSDL(con, ServletAdapter.getBaseAddress(request), request.getQueryString());
    }

    static String getBaseAddress(HttpServletRequest request) {
        StringBuilder addrBuf = new StringBuilder();
        addrBuf.append(request.getScheme());
        addrBuf.append("://");
        addrBuf.append(request.getServerName());
        addrBuf.append(':');
        addrBuf.append(request.getServerPort());
        addrBuf.append(request.getContextPath());
        return addrBuf.toString();
    }
}

