/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.server.ServerMgr;
import com.sun.xml.ws.transport.http.server.WSHttpHandler;
import java.util.concurrent.Executor;
import javax.xml.ws.EndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HttpEndpoint {
    private String address;
    private HttpContext httpContext;
    private final HttpAdapter adapter;
    private final Executor executor;

    public HttpEndpoint(WSEndpoint endpoint, Executor executor) {
        this.executor = executor;
        this.adapter = HttpAdapter.createAlone(endpoint);
    }

    public void publish(String address) {
        this.address = address;
        this.httpContext = ServerMgr.getInstance().createContext(address);
        this.publish(this.httpContext);
    }

    public void publish(Object serverContext) {
        if (!(serverContext instanceof HttpContext)) {
            throw new ServerRtException("not.HttpContext.type", serverContext.getClass());
        }
        this.httpContext = (HttpContext)serverContext;
        this.publish(this.httpContext);
    }

    private String getEPRAddress() {
        if (this.address == null) {
            return this.httpContext.getServer().getAddress().toString();
        }
        return this.address;
    }

    public void stop() {
        if (this.address == null) {
            this.httpContext.getServer().removeContext(this.httpContext);
        } else {
            ServerMgr.getInstance().removeContext(this.httpContext);
        }
        this.adapter.getEndpoint().dispose();
    }

    private void publish(HttpContext context) {
        context.setHandler(new WSHttpHandler(this.adapter, this.executor));
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        WSEndpointImpl endpointImpl = (WSEndpointImpl)this.adapter.getEndpoint();
        return endpointImpl.getEndpointReference(clazz, this.getEPRAddress());
    }
}

