/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.ws.encoding.soap.SOAPConstants;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.server.InvokerTube;
import com.sun.xml.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.ws.util.QNameMap;
import javax.xml.namespace.QName;

public class SEIInvokerTube
extends InvokerTube {
    private final QNameMap<EndpointMethodHandler> methodHandlers;
    private static final String EMPTY_PAYLOAD_LOCAL = "";
    private static final String EMPTY_PAYLOAD_NSURI = "";
    private final SOAPVersion soapVersion;
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.soapVersion = binding.getSOAPVersion();
        this.binding = binding;
        this.model = model;
        this.methodHandlers = new QNameMap();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            EndpointMethodHandler handler = new EndpointMethodHandler(this, model, m, binding);
            QName payloadName = model.getQNameForJM(m);
            this.methodHandlers.put(payloadName.getNamespaceURI(), payloadName.getLocalPart(), handler);
        }
    }

    public NextAction processRequest(Packet req) {
        Packet res;
        String nsUri;
        Message msg = req.getMessage();
        String localPart = msg.getPayloadLocalPart();
        if (localPart == null) {
            localPart = "";
            nsUri = "";
        } else {
            nsUri = msg.getPayloadNamespaceURI();
        }
        EndpointMethodHandler handler = this.methodHandlers.get(nsUri, localPart);
        if (handler == null) {
            String faultString = "Cannot find dispatch method for {" + nsUri + "}" + localPart;
            QName faultCode = this.soapVersion == SOAPVersion.SOAP_11 ? SOAPConstants.FAULT_CODE_CLIENT : SOAP12Constants.FAULT_CODE_CLIENT;
            Message faultMsg = SOAPFaultBuilder.createSOAPFaultMessage(this.soapVersion, faultString, faultCode);
            res = req.createServerResponse(faultMsg, this.model.getPort(), this.binding);
        } else {
            res = handler.invoke(req);
        }
        return this.doReturnWith(res);
    }

    public NextAction processResponse(Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

