/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server.provider;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.EndpointMessageContextImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import com.sun.xml.ws.server.provider.ProviderArgumentsBuilder;
import com.sun.xml.ws.server.provider.ProviderInvokerTube;
import java.security.Principal;
import java.util.logging.Logger;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncProviderInvokerTube<T>
extends ProviderInvokerTube<T> {
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.AsyncProviderInvokerTube");

    public AsyncProviderInvokerTube(Invoker invoker, ProviderArgumentsBuilder<T> argsBuilder) {
        super(invoker, argsBuilder);
    }

    @Override
    public NextAction processRequest(Packet request) {
        Object param = this.argsBuilder.getParameter(request.getMessage());
        AsyncProviderCallbackImpl callback = new AsyncProviderCallbackImpl(request);
        AsyncWebServiceContext ctxt = new AsyncWebServiceContext(this.getEndpoint(), request);
        logger.fine("Invoking AsyncProvider Endpoint");
        try {
            this.getInvoker(request).invokeAsyncProvider(request, param, callback, ctxt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.doThrow(e);
        }
        return this.doSuspend();
    }

    @Override
    public NextAction processResponse(Packet response) {
        return this.doReturnWith(response);
    }

    @Override
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("AsyncProviderInvokerTube's processException shouldn't be called.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AsyncWebServiceContext
    implements WSWebServiceContext {
        final Packet packet;
        final WSEndpoint endpoint;

        AsyncWebServiceContext(WSEndpoint endpoint, Packet packet) {
            this.packet = packet;
            this.endpoint = endpoint;
        }

        public MessageContext getMessageContext() {
            return new EndpointMessageContextImpl(this.getRequestPacket());
        }

        public Principal getUserPrincipal() {
            return this.packet.webServiceContextDelegate.getUserPrincipal(this.packet);
        }

        @Override
        @NotNull
        public Packet getRequestPacket() {
            return this.packet;
        }

        public boolean isUserInRole(String role) {
            Packet packet = this.getRequestPacket();
            return packet.webServiceContextDelegate.isUserInRole(packet, role);
        }

        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            Packet packet = this.getRequestPacket();
            String address = packet.webServiceContextDelegate.getEPRAddress(packet, this.endpoint);
            return ((WSEndpointImpl)this.endpoint).getEndpointReference(clazz, address);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncProviderCallbackImpl
    implements AsyncProviderCallback<T> {
        private final Packet request;
        private final Fiber fiber;

        public AsyncProviderCallbackImpl(Packet request) {
            this.request = request;
            this.fiber = Fiber.current();
        }

        @Override
        public void send(T param) {
            Message responseMessage = AsyncProviderInvokerTube.this.argsBuilder.getResponse(param);
            Packet packet = this.request.createServerResponse(responseMessage, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }

        @Override
        public void sendError(Throwable t) {
            RuntimeException e = t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            Message responseMessage = AsyncProviderInvokerTube.this.argsBuilder.getResponseMessage(e);
            Packet packet = this.request.createServerResponse(responseMessage, AsyncProviderInvokerTube.this.getEndpoint().getPort(), AsyncProviderInvokerTube.this.getEndpoint().getBinding());
            this.fiber.resume(packet);
        }
    }
}

