/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.model.wsdl;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.wsdl.AbstractExtensibleImpl;
import com.sun.xml.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.exception.LocatableWebServiceException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceFeature;

public final class WSDLPortImpl
extends AbstractExtensibleImpl
implements WSDLPort {
    private final QName name;
    private EndpointAddress address;
    private final QName bindingName;
    private final WSDLServiceImpl owner;
    private List<WebServiceFeature> features;
    private WSDLBoundPortTypeImpl boundPortType;

    public WSDLPortImpl(XMLStreamReader xsr, WSDLServiceImpl owner, QName name, QName binding) {
        super(xsr);
        this.owner = owner;
        this.name = name;
        this.bindingName = binding;
    }

    public QName getName() {
        return this.name;
    }

    public QName getBindingName() {
        return this.bindingName;
    }

    public EndpointAddress getAddress() {
        return this.address;
    }

    public WSDLServiceImpl getOwner() {
        return this.owner;
    }

    public WebServiceFeature getFeature(String id) {
        if (this.features != null) {
            for (WebServiceFeature f : this.features) {
                if (!f.getID().equals(id)) continue;
                return f;
            }
        }
        return this.boundPortType.getFeature(id);
    }

    public void addFeature(WebServiceFeature feature) {
        if (this.features == null) {
            this.features = new ArrayList<WebServiceFeature>();
        }
        this.features.add(feature);
    }

    public void setAddress(EndpointAddress address) {
        assert (address != null);
        this.address = address;
    }

    public WSDLBoundPortTypeImpl getBinding() {
        return this.boundPortType;
    }

    public SOAPVersion getSOAPVersion() {
        return this.boundPortType.getSOAPVersion();
    }

    void freeze(WSDLModelImpl root) {
        this.boundPortType = root.getBinding(this.bindingName);
        if (this.boundPortType == null) {
            throw new LocatableWebServiceException(ClientMessages.UNDEFINED_BINDING(this.bindingName), this.getLocation());
        }
    }
}

