/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.Closeable;
import com.sun.xml.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.client.ContainerResolver;
import com.sun.xml.ws.api.client.PortCreationCallback;
import com.sun.xml.ws.api.client.WSBindingProvider;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Stubs;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.HandlerResolverImpl;
import com.sun.xml.ws.client.PortInfo;
import com.sun.xml.ws.client.SEIPortInfo;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.ws.handler.PortInfoImpl;
import com.sun.xml.ws.model.AbstractSEIModelImpl;
import com.sun.xml.ws.model.RuntimeModeler;
import com.sun.xml.ws.model.SOAPSEIModel;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.resources.ClientMessages;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.jws.HandlerChain;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.SOAPBinding;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceDelegate
extends WSService {
    private final Map<QName, PortInfo> ports = new HashMap<QName, PortInfo>();
    private HandlerResolver handlerResolver;
    private final Class<? extends Service> serviceClass;
    @NotNull
    private final QName serviceName;
    private final Map<Class, SEIPortInfo> seiContext = new HashMap<Class, SEIPortInfo>();
    private final HashMap<QName, Set<String>> rolesMap = new HashMap();
    private Executor executor;
    @Nullable
    private final WSDLServiceImpl wsdlService;
    private final Container container;
    @Nullable
    private final PortCreationCallback portCreationCallback;
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    public WSServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class<? extends Service> serviceClass) {
        this(wsdlDocumentLocation == null ? null : new StreamSource(wsdlDocumentLocation.toExternalForm()), serviceName, serviceClass);
    }

    public WSServiceDelegate(@Nullable Source wsdl, @NotNull QName serviceName, final @NotNull Class<? extends Service> serviceClass) {
        HandlerChain handlerChain;
        if (serviceName == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME_NULL(serviceName));
        }
        this.serviceName = serviceName;
        this.serviceClass = serviceClass;
        this.container = ContainerResolver.getInstance().getContainer();
        this.portCreationCallback = this.container.getSPI(PortCreationCallback.class);
        WSDLServiceImpl service = null;
        if (wsdl != null) {
            try {
                URL url = wsdl.getSystemId() == null ? null : new URL(wsdl.getSystemId());
                WSDLModelImpl model = this.parseWSDL(url, wsdl);
                service = model.getService(this.serviceName);
                if (service == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(model.getServices().keySet())));
                }
                for (WSDLPortImpl port : service.getPorts()) {
                    this.ports.put(port.getName(), new PortInfo(this, port));
                }
            }
            catch (MalformedURLException e) {
                throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(wsdl.getSystemId()));
            }
        }
        this.wsdlService = service;
        if (serviceClass != Service.class && (handlerChain = AccessController.doPrivileged(new PrivilegedAction<HandlerChain>(){

            @Override
            public HandlerChain run() {
                return serviceClass.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            HandlerResolverImpl hresolver = new HandlerResolverImpl(this);
            this.setHandlerResolver(hresolver);
        }
    }

    private WSDLModelImpl parseWSDL(URL wsdlDocumentLocation, Source wsdl) {
        try {
            return RuntimeWSDLParser.parse(wsdlDocumentLocation, wsdl, XmlUtil.createDefaultCatalogResolver(), true, ServiceFinder.find(WSDLParserExtension.class).toArray());
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (ServiceConfigurationError e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private void validateEPR(WSDLModelImpl eprWsdlContext, EndpointReferenceInfo eprInfo) {
        if (this.wsdlService != null) {
            if (!eprWsdlContext.getFirstServiceName().equals(this.serviceName)) {
                throw new WebServiceException("EndpointReference WSDL ServiceName differs from Service Instance WSDL Service QName.\n The two Service QNames must match");
            }
            QName portName = eprInfo.pname;
            if (eprWsdlContext.getBinding(eprInfo.sname, portName) == null || this.wsdlService.get(portName) == null) {
                throw new WebServiceException("EndpointReference WSDL port name differs from Service Instance WSDL port QName.\n");
            }
        } else {
            WSDLServiceImpl eprService = eprWsdlContext.getService(this.serviceName);
            if (eprService == null) {
                throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(eprWsdlContext.getServices().keySet())));
            }
        }
    }

    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory());
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver resolver) {
        this.handlerResolver = resolver;
    }

    public <T> T getPort(QName portName, Class<T> portInterface) throws WebServiceException {
        return this.getPort(portName, portInterface, EMPTY_FEATURES);
    }

    public <T> T getPort(QName portName, Class<T> portInterface, WebServiceFeature ... features) {
        if (portName == null || portInterface == null) {
            throw new IllegalArgumentException();
        }
        this.addSEI(portName, portInterface);
        return this.createEndpointIFBaseProxy(null, portName, portInterface, features);
    }

    public <T> T getPort(EndpointReference epr, Class<T> portInterface, WebServiceFeature ... features) {
        QName portTypeName = RuntimeModeler.getPortTypeName(portInterface);
        WSDLPortImpl port = this.wsdlService.getMatchingPort(portTypeName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(portTypeName));
        }
        QName portName = port.getName();
        this.addSEI(portName, portInterface);
        return this.createEndpointIFBaseProxy(epr, portName, portInterface, features);
    }

    public <T> T getPort(Class<T> portInterface, WebServiceFeature ... features) {
        return this.getPort((EndpointReference)null, portInterface, features);
    }

    public <T> T getPort(Class<T> portInterface) throws WebServiceException {
        return this.getPort(portInterface, EMPTY_FEATURES);
    }

    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (this.ports.containsKey(portName)) {
            throw new WebServiceException("WSDLPort " + portName.toString() + " already exists can not create a port with the same name.");
        }
        BindingID bid = bindingId == null ? BindingID.SOAP11_HTTP : BindingID.parse(bindingId);
        this.ports.put(portName, new PortInfo(this, EndpointAddress.create(endpointAddress), portName, bid));
    }

    QName addPort(EndpointReferenceInfo eprinfo) throws WebServiceException {
        QName portQName = eprinfo.pname;
        PortInfo portInfo = new PortInfo(this, EndpointAddress.create(eprinfo.uri), portQName, this.getPortModel(portQName).getBinding().getBindingId());
        if (!this.ports.containsKey(portQName)) {
            this.ports.put(portQName, portInfo);
        }
        return portQName;
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(portName, aClass, mode, EMPTY_FEATURES);
    }

    private <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode, WebServiceFeature[] features, EndpointReference epr) {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding(features);
        return Stubs.createDispatch(portName, this, binding, aClass, mode, this.createPipeline(port, binding), WSEndpointReference.create(epr));
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> aClass, Service.Mode mode, WebServiceFeature ... features) {
        return this.createDispatch(portName, aClass, mode, features, (EndpointReference)null);
    }

    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        EndpointReferenceInfo eprInfo = new EndpointReferenceInfo(endpointReference);
        eprInfo.parseModel();
        QName portName = this.addPort(eprInfo);
        return this.createDispatch(portName, type, mode, features, endpointReference);
    }

    @NotNull
    public PortInfo safeGetPort(QName portName) {
        PortInfo port = this.ports.get(portName);
        if (port == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(portName, this.buildNameList(this.ports.keySet())));
        }
        return port;
    }

    private StringBuilder buildNameList(Collection<QName> names) {
        StringBuilder sb = new StringBuilder();
        for (QName qn : names) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(qn);
        }
        return sb;
    }

    private Tube createPipeline(PortInfo portInfo, WSBinding binding) {
        BindingID bindingId = portInfo.bindingId;
        TubelineAssembler assembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), bindingId);
        if (assembler == null) {
            throw new WebServiceException("Unable to process bindingID=" + bindingId);
        }
        return assembler.createClient(new ClientTubeAssemblerContext(portInfo.targetEndpoint, portInfo.portModel, this, binding, this.container));
    }

    public EndpointAddress getEndpointAddress(QName qName) {
        return this.ports.get((Object)qName).targetEndpoint;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(portName, jaxbContext, mode, EMPTY_FEATURES);
    }

    private Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode, WebServiceFeature[] features, EndpointReference epr) {
        PortInfo port = this.safeGetPort(portName);
        BindingImpl binding = port.createBinding(features);
        return Stubs.createJAXBDispatch(portName, this, binding, jaxbContext, mode, this.createPipeline(port, binding), WSEndpointReference.create(epr));
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext jaxbContext, Service.Mode mode, WebServiceFeature ... webServiceFeatures) {
        return this.createDispatch(portName, jaxbContext, mode, webServiceFeatures, (EndpointReference)null);
    }

    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        EndpointReferenceInfo eprInfo = new EndpointReferenceInfo(endpointReference);
        eprInfo.parseModel();
        QName portName = this.addPort(eprInfo);
        return this.createDispatch(portName, context, mode, features, endpointReference);
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    protected Class getServiceClass() {
        return this.serviceClass;
    }

    protected Set<String> getRoles(QName portName) {
        return this.rolesMap.get(portName);
    }

    protected void setRoles(QName portName, Set<String> roles) {
        this.rolesMap.put(portName, roles);
    }

    public Iterator<QName> getPorts() throws WebServiceException {
        if (this.ports.isEmpty()) {
            throw new WebServiceException("dii.service.no.wsdl.available");
        }
        return this.ports.keySet().iterator();
    }

    public URL getWSDLDocumentLocation() {
        if (this.wsdlService == null) {
            return null;
        }
        try {
            return new URL(this.wsdlService.getParent().getLocation().getSystemId());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <T> T createEndpointIFBaseProxy(@Nullable EndpointReference epr, QName portName, Class<T> portInterface, WebServiceFeature[] webServiceFeatures) {
        if (this.wsdlService == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NO_WSDL(this.serviceName));
        }
        if (this.wsdlService.get(portName) == null) {
            throw new WebServiceException("WSDLPort " + portName + "is not found in service " + this.serviceName);
        }
        SEIPortInfo eif = this.seiContext.get(portInterface);
        BindingImpl binding = eif.createBinding(webServiceFeatures);
        SEIStub pis = new SEIStub(this, binding, eif.model, this.createPipeline(eif, binding), WSEndpointReference.create(epr));
        T proxy = portInterface.cast(Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, WSBindingProvider.class, Closeable.class}, (InvocationHandler)pis));
        if (this.portCreationCallback != null) {
            this.portCreationCallback.proxyCreated((WSBindingProvider)proxy, portInterface);
        }
        return proxy;
    }

    protected BindingImpl createBinding(QName portName, BindingID bindingId) {
        return this.createBinding(portName, bindingId, EMPTY_FEATURES);
    }

    protected BindingImpl createBinding(QName portName, BindingID bindingId, WebServiceFeature ... webServiceFeatures) {
        Set<String> roles;
        ArrayList<Handler> handlerChain;
        if (this.handlerResolver != null) {
            PortInfoImpl portInfo = new PortInfoImpl(bindingId, portName, this.serviceName);
            handlerChain = this.handlerResolver.getHandlerChain((javax.xml.ws.handler.PortInfo)portInfo);
        } else {
            handlerChain = new ArrayList();
        }
        BindingImpl bindingImpl = BindingImpl.create(bindingId, webServiceFeatures);
        PortInfo portInfo = this.ports.get(portName);
        if (portInfo.portModel != null && portInfo.portModel.getBinding().isMTOMEnabled()) {
            bindingImpl.setMTOMEnabled(true);
        }
        if (bindingImpl instanceof SOAPBinding && (roles = this.rolesMap.get(portName)) != null) {
            ((SOAPBinding)bindingImpl).setRoles(roles);
        }
        bindingImpl.setHandlerChain(handlerChain);
        return bindingImpl;
    }

    public WSDLPortImpl getPortModel(QName portName) {
        WSDLPortImpl port = this.wsdlService.get(portName);
        if (port == null) {
            throw new WebServiceException("Port \"" + portName + "\" not found in service \"" + this.serviceName + "\"");
        }
        return port;
    }

    private void addSEI(QName portName, Class portInterface) throws WebServiceException {
        SEIPortInfo spi = this.seiContext.get(portInterface);
        if (spi != null) {
            return;
        }
        WSDLPortImpl wsdlPort = this.getPortModel(portName);
        RuntimeModeler modeler = new RuntimeModeler(portInterface, this.serviceName, wsdlPort);
        modeler.setPortName(portName);
        AbstractSEIModelImpl model = modeler.buildRuntimeModel();
        spi = new SEIPortInfo(this, portInterface, (SOAPSEIModel)model, wsdlPort);
        this.seiContext.put(spi.sei, spi);
        this.ports.put(spi.portName, spi);
    }

    public WSDLServiceImpl getWsdlService() {
        return this.wsdlService;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }

    class EndpointReferenceInfo {
        @NotNull
        private final MemberSubmissionEndpointReference msepr;
        final String uri;
        final QName sname;
        final QName pname;

        EndpointReferenceInfo(EndpointReference epr) {
            this.msepr = epr.getClass().isAssignableFrom(MemberSubmissionEndpointReference.class) ? (MemberSubmissionEndpointReference)epr : EndpointReferenceUtil.transform(MemberSubmissionEndpointReference.class, epr);
            this.uri = this.msepr.addr.uri;
            this.sname = this.msepr.serviceName.name;
            this.pname = new QName(this.sname.getNamespaceURI(), this.msepr.serviceName.portName);
        }

        private WSDLModel parseModel() {
            WSDLModelImpl eprWsdlCtx;
            try {
                eprWsdlCtx = WSServiceDelegate.this.parseWSDL(new URL(this.uri), this.msepr.toWSDLSource());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            WSServiceDelegate.this.validateEPR(eprWsdlCtx, this);
            return eprWsdlCtx;
        }
    }
}

