/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.binding.BindingTypeImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.developer.MemberSubmissionAddressingFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortInfo {
    @NotNull
    private final WSServiceDelegate owner;
    @NotNull
    public final QName portName;
    @NotNull
    public final EndpointAddress targetEndpoint;
    @NotNull
    public final BindingID bindingId;
    @Nullable
    public final WSDLPort portModel;

    public PortInfo(WSServiceDelegate owner, EndpointAddress targetEndpoint, QName name, BindingID bindingId) {
        this.owner = owner;
        this.targetEndpoint = targetEndpoint;
        this.portName = name;
        this.bindingId = bindingId;
        this.portModel = this.getPortModel(owner, name);
    }

    public PortInfo(@NotNull WSServiceDelegate owner, @NotNull WSDLPort port) {
        this.owner = owner;
        this.targetEndpoint = port.getAddress();
        this.portName = port.getName();
        this.bindingId = port.getBinding().getBindingId();
        this.portModel = port;
    }

    public BindingImpl createBinding() {
        return this.owner.createBinding(this.portName, this.bindingId);
    }

    protected List<WebServiceFeature> extractWSDLFeatures() {
        ArrayList<WebServiceFeature> wsdlFeatures = null;
        if (this.portModel != null) {
            WebServiceFeature wsdlFastInfosetFeature;
            WebServiceFeature wsdlMTOMFeature;
            wsdlFeatures = new ArrayList<WebServiceFeature>();
            WebServiceFeature wsdlAddressingFeature = this.portModel.getFeature("http://www.w3.org/2005/08/addressing/module");
            if (wsdlAddressingFeature != null) {
                if (((AddressingFeature)wsdlAddressingFeature).isRequired()) {
                    wsdlFeatures.add(wsdlAddressingFeature);
                }
            } else {
                wsdlAddressingFeature = this.portModel.getFeature("http://java.sun.com/xml/ns/jaxws/2004/08/addressing");
                if (wsdlAddressingFeature != null && ((MemberSubmissionAddressingFeature)wsdlAddressingFeature).isRequired()) {
                    wsdlFeatures.add(wsdlAddressingFeature);
                }
            }
            if ((wsdlMTOMFeature = this.portModel.getFeature("http://www.w3.org/2004/08/soap/features/http-optimization")) != null) {
                wsdlFeatures.add(wsdlMTOMFeature);
            }
            if ((wsdlFastInfosetFeature = this.portModel.getFeature("http://java.sun.com/xml/ns/jaxws/fastinfoset")) != null) {
                wsdlFeatures.add(wsdlFastInfosetFeature);
            }
        }
        return wsdlFeatures;
    }

    public BindingImpl createBinding(WebServiceFeature[] webServiceFeatures) {
        return this.owner.createBinding(this.portName, this.bindingId, this.resolveFeatures(webServiceFeatures));
    }

    private WSDLPort getPortModel(WSServiceDelegate owner, QName portName) {
        if (owner.getWsdlService() != null) {
            return owner.getPortModel(portName);
        }
        return null;
    }

    protected WebServiceFeature[] resolveFeatures(WebServiceFeature[] webServiceFeatures) {
        if (!BindingTypeImpl.isFeatureEnabled("javax.xml.ws.InspectBindingFeature", webServiceFeatures)) {
            return webServiceFeatures;
        }
        Map<String, WebServiceFeature> featureMap = PortInfo.fillMap(webServiceFeatures);
        List<WebServiceFeature> wsdlFeatures = this.extractWSDLFeatures();
        for (WebServiceFeature ftr : wsdlFeatures) {
            if (featureMap.get(ftr.getID()) != null) continue;
            featureMap.put(ftr.getID(), ftr);
        }
        return featureMap.values().toArray(new WebServiceFeature[featureMap.size()]);
    }

    protected static Map<String, WebServiceFeature> fillMap(WebServiceFeature[] webServiceFeatures) {
        HashMap<String, WebServiceFeature> featureMap = new HashMap<String, WebServiceFeature>(5);
        if (webServiceFeatures != null) {
            for (int i = 0; i < webServiceFeatures.length; ++i) {
                featureMap.put(webServiceFeatures[i].getID(), webServiceFeatures[i]);
            }
        }
        return featureMap;
    }
}

