/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.BindingTypeImpl;
import com.sun.xml.ws.binding.HTTPBindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.model.RuntimeModelerException;
import com.sun.xml.ws.resources.ModelerMessages;
import com.sun.xml.ws.resources.ServerMessages;
import com.sun.xml.ws.server.ServerRtException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.MTOMFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements WSBinding {
    private HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    private Map<String, WebServiceFeature> features;
    private AddressingVersion addressingVersion = null;

    protected BindingImpl(BindingID bindingId) {
        this.bindingId = bindingId;
        this.setHandlerConfig(this.createHandlerConfig(Collections.<Handler>emptyList()));
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setHandlerChain(List<Handler> chain) {
        this.setHandlerConfig(this.createHandlerConfig(chain));
    }

    protected void setHandlerConfig(HandlerConfiguration handlerConfig) {
        this.handlerConfig = handlerConfig;
    }

    protected abstract HandlerConfiguration createHandlerConfig(List<Handler> var1);

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public boolean isMTOMEnabled() {
        return false;
    }

    @Override
    public void setMTOMEnabled(boolean value) {
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }

    private boolean hasFeature(String featureId) {
        if (featureId == null || this.features == null) {
            return false;
        }
        return this.features.containsKey(featureId);
    }

    @Override
    public WebServiceFeature getFeature(String featureId) {
        if (featureId == null || this.features == null) {
            return null;
        }
        return this.features.get(featureId);
    }

    @Override
    public boolean isFeatureEnabled(String featureId) {
        if (!this.hasFeature(featureId)) {
            return false;
        }
        return this.features.get(featureId).isEnabled();
    }

    private void updateCache() {
        this.addressingVersion = this.isFeatureEnabled("http://www.w3.org/2005/08/addressing/module") ? AddressingVersion.W3C : (this.isFeatureEnabled("http://java.sun.com/xml/ns/jaxws/2004/08/addressing") ? AddressingVersion.MEMBER : null);
    }

    private void enableFeature(WebServiceFeature feature) {
        if (feature == null) {
            return;
        }
        if (this.features == null) {
            this.features = new HashMap<String, WebServiceFeature>();
        }
        this.features.put(feature.getID(), feature);
        this.updateCache();
    }

    @Override
    public void setFeatures(WebServiceFeature ... newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.enableFeature(f);
            }
        }
    }

    public void addFeature(@NotNull WebServiceFeature newFeature) {
        this.enableFeature(newFeature);
    }

    public boolean isAddressingEnabled() {
        return this.addressingVersion != null;
    }

    public static WSBinding create(String ddBindingId, Class implClass, String mtomEnabled, String mtomThreshold, WebServiceFeature[] features) {
        BindingID bindingID;
        WebServiceFeature[] implFeatures = BindingTypeImpl.parseBindingType(implClass);
        MTOMFeature mtomfeature = null;
        if (ddBindingId != null) {
            bindingID = BindingID.parse(ddBindingId);
            if (bindingID.isMTOMEnabled() == null) {
                mtomfeature = mtomEnabled != null ? (mtomThreshold != null ? new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue(), Integer.valueOf(mtomThreshold).intValue()) : new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue())) : (MTOMFeature)BindingTypeImpl.getFeature("http://www.w3.org/2004/08/soap/features/http-optimization", implFeatures);
            } else if (mtomEnabled != null && Boolean.valueOf(mtomEnabled) != bindingID.isMTOMEnabled()) {
                throw new ServerRtException(ServerMessages.DD_MTOM_CONFLICT(ddBindingId, mtomEnabled), new Object[0]);
            }
        } else {
            bindingID = BindingID.parse(implClass);
            if (mtomEnabled != null) {
                mtomfeature = mtomThreshold != null ? new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue(), Integer.valueOf(mtomThreshold).intValue()) : new MTOMFeature(Boolean.valueOf(mtomEnabled).booleanValue());
            } else {
                mtomfeature = (MTOMFeature)BindingTypeImpl.getFeature("http://www.w3.org/2004/08/soap/features/http-optimization", implFeatures);
                if (bindingID.isMTOMEnabled() != null && mtomfeature != null && mtomfeature.isEnabled() != bindingID.isMTOMEnabled().booleanValue()) {
                    throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_MTOM_CONFLICT(bindingID, mtomfeature.isEnabled()), new Object[0]);
                }
            }
        }
        BindingImpl binding = BindingImpl.create(bindingID, implFeatures);
        if (mtomfeature != null) {
            binding.enableFeature((WebServiceFeature)mtomfeature);
        }
        return binding;
    }
}

