/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSEndpoint<T> {
    @NotNull
    public abstract Codec createCodec();

    @NotNull
    public abstract QName getServiceName();

    @NotNull
    public abstract QName getPortName();

    @NotNull
    public abstract Class<T> getImplementationClass();

    @NotNull
    public abstract WSBinding getBinding();

    @NotNull
    public abstract Container getContainer();

    @Nullable
    public abstract WSDLPort getPort();

    public abstract void setExecutor(@NotNull Executor var1);

    public final void schedule(@NotNull Packet request, @NotNull Fiber.CompletionCallback callback) {
        this.schedule(request, callback, null);
    }

    public abstract void schedule(@NotNull Packet var1, @NotNull Fiber.CompletionCallback var2, @Nullable FiberContextSwitchInterceptor var3);

    @NotNull
    public abstract PipeHead createPipeHead();

    public abstract void dispose();

    @Nullable
    public abstract ServiceDefinition getServiceDefinition();

    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable EntityResolver resolver, boolean isTransportSynchronous) {
        return EndpointFactory.createEndpoint(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, isTransportSynchronous);
    }

    @Deprecated
    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable EntityResolver resolver) {
        return WSEndpoint.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, resolver, false);
    }

    public static <T> WSEndpoint<T> create(@NotNull Class<T> implType, boolean processHandlerAnnotation, @Nullable Invoker invoker, @Nullable QName serviceName, @Nullable QName portName, @Nullable Container container, @Nullable WSBinding binding, @Nullable SDDocumentSource primaryWsdl, @Nullable Collection<? extends SDDocumentSource> metadata, @Nullable URL catalogUrl) {
        return WSEndpoint.create(implType, processHandlerAnnotation, invoker, serviceName, portName, container, binding, primaryWsdl, metadata, XmlUtil.createEntityResolver(catalogUrl));
    }

    @NotNull
    public static QName getDefaultServiceName(Class endpointClass) {
        return EndpointFactory.getDefaultServiceName(endpointClass);
    }

    @NotNull
    public static QName getDefaultPortName(@NotNull QName serviceName, Class endpointClass) {
        return EndpointFactory.getDefaultPortName(serviceName, endpointClass);
    }

    public static interface PipeHead {
        @NotNull
        public Packet process(@NotNull Packet var1, @Nullable WebServiceContextDelegate var2, @Nullable TransportBackChannel var3);
    }
}

