/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLFault;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.model.wsdl.WSDLOperationImpl;
import java.util.Map;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;

public abstract class WsaPipeHelper {
    protected Unmarshaller unmarshaller;
    protected Marshaller marshaller;
    protected WSDLPort wsdlPort;
    protected WSBinding binding;

    private String getFaultAction(Packet packet) {
        String action = this.binding.getAddressingVersion().getDefaultFaultAction();
        if (this.wsdlPort == null) {
            return null;
        }
        try {
            WSDLOperation o;
            SOAPMessage sm = packet.getMessage().readAsSOAPMessage();
            if (sm == null) {
                return action;
            }
            if (sm.getSOAPBody() == null) {
                return action;
            }
            if (sm.getSOAPBody().getFault() == null) {
                return action;
            }
            Detail detail = sm.getSOAPBody().getFault().getDetail();
            if (detail == null) {
                return action;
            }
            String ns = detail.getFirstChild().getNamespaceURI();
            String name = detail.getFirstChild().getLocalName();
            WSDLBoundOperation wbo = null;
            if (this.wsdlPort != null) {
                wbo = packet.getMessage().getOperation(this.wsdlPort);
            }
            if ((o = wbo.getOperation()) == null) {
                return action;
            }
            WSDLFault fault = o.getFault(new QName(ns, name));
            if (fault == null) {
                return action;
            }
            WSDLOperationImpl impl = (WSDLOperationImpl)o;
            Map<String, String> map = impl.getFaultActionMap();
            if (map == null) {
                return action;
            }
            action = map.get(fault.getName());
            return action;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public String getInputAction(Packet packet) {
        WSDLOperation op;
        WSDLBoundOperation wbo;
        String action = null;
        if (this.wsdlPort != null && this.wsdlPort.getBinding() != null && (wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart())) != null && (op = wbo.getOperation()) != null) {
            action = op.getInput().getAction();
        }
        return action;
    }

    public boolean isInputActionDefault(Packet packet) {
        if (this.wsdlPort == null) {
            return false;
        }
        if (this.wsdlPort.getBinding() == null) {
            return false;
        }
        WSDLBoundOperation wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart());
        if (wbo == null) {
            return false;
        }
        WSDLOperation op = wbo.getOperation();
        if (op == null) {
            return false;
        }
        return ((WSDLOperationImpl)op).getInput().isDefaultAction();
    }

    public String getSOAPAction(Packet packet) {
        String action = "";
        if (packet == null) {
            return action;
        }
        if (packet.getMessage() == null) {
            return action;
        }
        WSDLBoundOperation op = packet.getMessage().getOperation(this.wsdlPort);
        if (op == null) {
            return action;
        }
        action = op.getSOAPAction();
        return action;
    }

    public String getOutputAction(Packet packet) {
        WSDLOperation op;
        WSDLBoundOperation wbo;
        String action = "http://jax-ws.dev.java.net/addressing/output-action-not-set";
        if (this.wsdlPort != null && this.wsdlPort.getBinding() != null && (wbo = this.wsdlPort.getBinding().getOperation(packet.getMessage().getPayloadNamespaceURI(), packet.getMessage().getPayloadLocalPart())) != null && (op = wbo.getOperation()) != null) {
            action = op.getOutput().getAction();
        }
        return action;
    }

    public SOAPFault newActionNotSupportedFault(String action, AddressingVersion av) {
        QName subcode = av.actionNotSupportedTag;
        String faultstring = String.format(av.actionNotSupportedText, action);
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                this.getProblemActionDetail(action, (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public SOAPFault newInvalidMapFault(InvalidMapException e, AddressingVersion av) {
        QName name = e.getMapQName();
        QName subsubcode = e.getSubsubcode();
        QName subcode = av.invalidMapTag;
        String faultstring = String.format(av.getInvalidMapText(), name, subsubcode);
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getInvalidMapDetail(name, (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    public SOAPFault newMapRequiredFault(MapRequiredException e, AddressingVersion av) {
        QName subcode = av.mapRequiredTag;
        QName subsubcode = av.mapRequiredTag;
        String faultstring = av.getMapRequiredText();
        try {
            SOAPFault fault;
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_12) {
                SOAPFactory factory = SOAPVersion.SOAP_12.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                fault.appendFaultSubcode(subcode);
                fault.appendFaultSubcode(subsubcode);
                this.getMapRequiredDetail(e.getMapQName(), (Element)fault.addDetail());
            } else {
                SOAPFactory factory = SOAPVersion.SOAP_11.saajSoapFactory;
                fault = factory.createFault();
                fault.setFaultCode(subsubcode);
            }
            fault.setFaultString(faultstring);
            return fault;
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    public abstract void getProblemActionDetail(String var1, Element var2);

    public abstract void getInvalidMapDetail(QName var1, Element var2);

    public abstract void getMapRequiredDetail(QName var1, Element var2);
}

