/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.W3CAddressingConstants;
import com.sun.xml.ws.addressing.WsaPipeHelper;
import com.sun.xml.ws.addressing.WsaPipeHelperImpl;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.addressing.model.InvalidMapException;
import com.sun.xml.ws.addressing.model.MapRequiredException;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.addressing.WSEndpointReference;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.message.FaultDetailHeader;
import com.sun.xml.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.ws.resources.AddressingMessages;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;

public abstract class WsaPipe
extends AbstractFilterTubeImpl {
    protected final WSDLPort wsdlPort;
    protected final WSBinding binding;
    final WsaPipeHelper helper;

    public WsaPipe(WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(next);
        this.wsdlPort = wsdlPort;
        this.binding = binding;
        this.helper = this.getPipeHelper();
    }

    public WsaPipe(WsaPipe that, TubeCloner cloner) {
        super(that, cloner);
        this.wsdlPort = that.wsdlPort;
        this.binding = that.binding;
        this.helper = that.helper;
    }

    public void preDestroy() {
    }

    @NotNull
    public NextAction processException(Throwable t) {
        return super.processException(t);
    }

    protected WsaPipeHelper getPipeHelper() {
        if (this.binding.isFeatureEnabled("http://www.w3.org/2005/08/addressing/module")) {
            return new WsaPipeHelperImpl(this.wsdlPort, this.binding);
        }
        if (this.binding.isFeatureEnabled("http://java.sun.com/xml/ns/jaxws/2004/08/addressing")) {
            return new com.sun.xml.ws.addressing.v200408.WsaPipeHelperImpl(this.wsdlPort, this.binding);
        }
        throw new WebServiceException(AddressingMessages.ADDRESSING_NOT_ENABLED(this.getClass().getSimpleName()));
    }

    public final Packet validateInboundHeaders(Packet packet) {
        FaultDetailHeader s11FaultDetailHeader;
        SOAPFault soapFault;
        try {
            this.checkCardinality(packet, this.binding, this.wsdlPort);
            if (this.isAddressingEngagedOrRequired(packet, this.binding)) {
                this.validateAction(packet);
            }
            return packet;
        }
        catch (InvalidMapException e) {
            soapFault = this.helper.newInvalidMapFault(e, this.binding.getAddressingVersion());
            s11FaultDetailHeader = new FaultDetailHeader(this.binding.getAddressingVersion(), this.binding.getAddressingVersion().problemHeaderQNameTag.getLocalPart(), e.getMapQName());
        }
        catch (MapRequiredException e) {
            soapFault = this.helper.newMapRequiredFault(e, this.binding.getAddressingVersion());
            s11FaultDetailHeader = new FaultDetailHeader(this.binding.getAddressingVersion(), this.binding.getAddressingVersion().problemHeaderQNameTag.getLocalPart(), e.getMapQName());
        }
        catch (ActionNotSupportedException e) {
            soapFault = this.helper.newActionNotSupportedFault(e.getAction(), this.binding.getAddressingVersion());
            s11FaultDetailHeader = new FaultDetailHeader(this.binding.getAddressingVersion(), this.binding.getAddressingVersion().problemHeaderQNameTag.getLocalPart(), e.getAction());
        }
        if (soapFault != null) {
            if (packet.getMessage().isOneWay(this.wsdlPort)) {
                return packet.createServerResponse(null, this.wsdlPort, this.binding);
            }
            Message m = Messages.create(soapFault);
            if (this.binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
                m.getHeaders().add(s11FaultDetailHeader);
            }
            Packet response = packet.createServerResponse(m, this.wsdlPort, this.binding);
            return response;
        }
        return packet;
    }

    final boolean isAddressingEngagedOrRequired(Packet packet, WSBinding binding) {
        if (AddressingVersion.isRequired(binding)) {
            return true;
        }
        if (packet == null) {
            return false;
        }
        if (packet.getMessage() == null) {
            return false;
        }
        if (packet.getMessage().getHeaders() != null) {
            return false;
        }
        String action = packet.getMessage().getHeaders().getAction(binding.getAddressingVersion(), binding.getSOAPVersion());
        if (action == null) {
            return true;
        }
        return true;
    }

    protected abstract void validateAction(Packet var1);

    public final void checkCardinality(Packet packet, WSBinding binding, WSDLPort wsdlPort) {
        Message message = packet.getMessage();
        AddressingVersion av = binding.getAddressingVersion();
        if (message == null) {
            if (AddressingVersion.isRequired(binding.getFeature(av.getFeatureID()))) {
                throw new WebServiceException(AddressingMessages.NULL_MESSAGE());
            }
            return;
        }
        if (message.getHeaders() == null) {
            if (AddressingVersion.isRequired(binding.getFeature(av.getFeatureID()))) {
                throw new WebServiceException(AddressingMessages.NULL_HEADERS());
            }
            return;
        }
        Iterator<Header> hIter = message.getHeaders().getHeaders(av.nsUri, true);
        if (!hIter.hasNext()) {
            if (AddressingVersion.isRequired(binding.getFeature(av.getFeatureID()))) {
                throw new InvalidMapException(av.actionTag, av.invalidCardinalityTag);
            }
            return;
        }
        boolean foundFrom = false;
        boolean foundTo = false;
        boolean foundReplyTo = false;
        boolean foundFaultTo = false;
        boolean foundAction = false;
        boolean foundMessageId = false;
        QName duplicateHeader = null;
        WSEndpointReference replyTo = null;
        WSEndpointReference faultTo = null;
        while (hIter.hasNext()) {
            Header h = hIter.next();
            if (!this.isInCurrentRole(h, binding)) continue;
            String local = h.getLocalPart();
            if (local.equals(av.fromTag.getLocalPart())) {
                if (foundFrom) {
                    duplicateHeader = av.fromTag;
                    break;
                }
                foundFrom = true;
                continue;
            }
            if (local.equals(av.toTag.getLocalPart())) {
                if (foundTo) {
                    duplicateHeader = av.toTag;
                    break;
                }
                foundTo = true;
                continue;
            }
            if (local.equals(av.replyToTag.getLocalPart())) {
                if (foundReplyTo) {
                    duplicateHeader = av.replyToTag;
                    break;
                }
                foundReplyTo = true;
                try {
                    replyTo = h.readAsEPR(binding.getAddressingVersion());
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(AddressingMessages.REPLY_TO_CANNOT_PARSE(), (Throwable)e);
                }
            }
            if (local.equals(av.faultToTag.getLocalPart())) {
                if (foundFaultTo) {
                    duplicateHeader = av.faultToTag;
                    break;
                }
                foundFaultTo = true;
                try {
                    faultTo = h.readAsEPR(binding.getAddressingVersion());
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(AddressingMessages.FAULT_TO_CANNOT_PARSE(), (Throwable)e);
                }
            }
            if (local.equals(av.actionTag.getLocalPart())) {
                if (foundAction) {
                    duplicateHeader = av.actionTag;
                    break;
                }
                foundAction = true;
                continue;
            }
            if (local.equals(av.messageIDTag.getLocalPart())) {
                if (foundMessageId) {
                    duplicateHeader = av.messageIDTag;
                    break;
                }
                foundMessageId = true;
                continue;
            }
            if (local.equals(av.relatesToTag.getLocalPart()) || local.equals(av.faultDetailTag.getLocalPart())) continue;
            throw new WebServiceException(AddressingMessages.UNKNOWN_WSA_HEADER());
        }
        if (duplicateHeader != null) {
            throw new InvalidMapException(duplicateHeader, av.invalidCardinalityTag);
        }
        boolean engaged = foundAction;
        if (engaged || AddressingVersion.isRequired(binding.getFeature(av.getFeatureID()))) {
            if (!foundAction) {
                throw new MapRequiredException(av.actionTag);
            }
            if (!foundTo) {
                throw new MapRequiredException(av.toTag);
            }
        }
        if (packet.proxy == null) {
            WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
            this.checkAnonymousSemantics(wbo, replyTo, faultTo);
        }
    }

    final boolean isInCurrentRole(Header header, WSBinding binding) {
        if (binding == null) {
            return true;
        }
        if (binding.getSOAPVersion() == SOAPVersion.SOAP_11) {
            return true;
        }
        String role = header.getRole(binding.getSOAPVersion());
        return role.equals(SOAPVersion.SOAP_12.implicitRole);
    }

    final WSDLBoundOperation getWSDLBoundOperation(Packet packet) {
        WSDLBoundOperation wbo = null;
        if (this.wsdlPort != null) {
            wbo = packet.getMessage().getOperation(this.wsdlPort);
        }
        return wbo;
    }

    final void checkAnonymousSemantics(WSDLBoundOperation wbo, WSEndpointReference replyTo, WSEndpointReference faultTo) {
        if (this.binding.getAddressingVersion() == null || this.binding.getAddressingVersion() == AddressingVersion.MEMBER) {
            return;
        }
        if (wbo == null) {
            return;
        }
        WSDLBoundOperationImpl impl = (WSDLBoundOperationImpl)wbo;
        WSDLBoundOperationImpl.ANONYMOUS anon = impl.getAnonymous();
        AddressingVersion av = this.binding.getAddressingVersion();
        String replyToValue = null;
        String faultToValue = null;
        if (replyTo != null) {
            replyToValue = replyTo.getAddress();
        }
        if (faultTo != null) {
            faultToValue = faultTo.getAddress();
        }
        if (anon != WSDLBoundOperationImpl.ANONYMOUS.optional) {
            if (anon == WSDLBoundOperationImpl.ANONYMOUS.required) {
                if (replyToValue != null && !replyToValue.equals(av.getAnonymousUri())) {
                    throw new InvalidMapException(av.replyToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue != null && !faultToValue.equals(av.getAnonymousUri())) {
                    throw new InvalidMapException(av.faultToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
            } else if (anon == WSDLBoundOperationImpl.ANONYMOUS.prohibited) {
                if (replyToValue != null && replyToValue.equals(av.getAnonymousUri())) {
                    throw new InvalidMapException(av.replyToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (faultToValue != null && faultToValue.equals(av.getAnonymousUri())) {
                    throw new InvalidMapException(av.faultToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
            } else {
                throw new WebServiceException(AddressingMessages.INVALID_WSAW_ANONYMOUS(anon.toString()));
            }
        }
    }
}

