/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.WsaPipe;
import com.sun.xml.ws.addressing.model.ActionNotSupportedException;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.resources.AddressingMessages;
import javax.xml.ws.WebServiceException;

public class WsaClientPipe
extends WsaPipe {
    public WsaClientPipe(WSDLPort wsdlPort, WSBinding binding, Tube next) {
        super(wsdlPort, binding, next);
    }

    public WsaClientPipe(WsaClientPipe that, TubeCloner cloner) {
        super(that, cloner);
    }

    public WsaClientPipe copy(TubeCloner cloner) {
        return new WsaClientPipe(this, cloner);
    }

    @NotNull
    public NextAction processRequest(Packet request) {
        if (this.wsdlPort == null) {
            return this.doInvoke(this.next, request);
        }
        if (AddressingVersion.fromBinding(this.binding) != null) {
            HeaderList headerList = request.getMessage().getHeaders();
            headerList.fillRequestAddressingHeaders(this.wsdlPort, this.binding, request);
        }
        return this.doInvoke(this.next, request);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        if (response.getMessage() != null) {
            response = this.validateInboundHeaders(response);
        }
        return this.doReturnWith(response);
    }

    public void validateAction(Packet packet) {
        WSDLBoundOperation wbo = this.getWSDLBoundOperation(packet);
        WSDLOperation op = null;
        if (wbo != null) {
            op = wbo.getOperation();
        }
        if (wbo == null || op == null) {
            return;
        }
        String gotA = packet.getMessage().getHeaders().getAction(this.binding.getAddressingVersion(), this.binding.getSOAPVersion());
        if (gotA == null) {
            throw new WebServiceException(AddressingMessages.VALIDATION_CLIENT_NULL_ACTION());
        }
        String expected = this.helper.getOutputAction(packet);
        if (expected != null && !gotA.equals(expected)) {
            throw new ActionNotSupportedException(gotA);
        }
    }
}

