/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.wsdl;

import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.ws.model.wsdl.WSDLServiceImpl;
import com.sun.xml.ws.util.ServiceConfigurationError;
import com.sun.xml.ws.util.ServiceFinder;
import com.sun.xml.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLContext {
    private final URL orgWsdlLocation;
    private String targetNamespace;
    private final WSDLModelImpl wsdlDoc;

    public WSDLContext(URL wsdlDocumentLocation, EntityResolver entityResolver) throws WebServiceException {
        assert (entityResolver != null);
        if (wsdlDocumentLocation == null) {
            throw new WebServiceException("No WSDL location Information present, error");
        }
        this.orgWsdlLocation = wsdlDocumentLocation;
        try {
            this.wsdlDoc = RuntimeWSDLParser.parse(wsdlDocumentLocation, entityResolver, ServiceFinder.find(WSDLParserExtension.class).toArray());
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (SAXException e) {
            throw new WebServiceException((Throwable)e);
        }
        catch (ServiceConfigurationError e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public WSDLModelImpl getWSDLModel() {
        return this.wsdlDoc;
    }

    public URL getWsdlLocation() {
        return this.orgWsdlLocation;
    }

    public String getOrigURLPath() {
        return this.orgWsdlLocation.getPath();
    }

    public QName getServiceQName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public QName getServiceQName(QName serviceName) {
        if (this.wsdlDoc.getServices().containsKey(serviceName)) {
            return serviceName;
        }
        throw new WebServiceException("Error supplied serviceQName is not correct.");
    }

    public EndpointAddress getEndpoint(QName serviceName) {
        WSDLPort port;
        if (serviceName == null) {
            throw new WebServiceException("Service unknown, can not identify ports for an unknown Service.");
        }
        WSDLServiceImpl service = this.wsdlDoc.getService(serviceName);
        EndpointAddress endpoint = null;
        if (service != null && (port = service.getFirstPort()) != null) {
            endpoint = port.getAddress();
        }
        if (endpoint == null) {
            throw new WebServiceException("Endpoint not found. Check WSDL file to verify endpoint was provided.");
        }
        return endpoint;
    }

    public QName getPortName() {
        return this.wsdlDoc.getFirstPortName();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public Iterable<WSDLPortImpl> getPorts(QName serviceName) {
        WSDLServiceImpl service = this.wsdlDoc.getService(serviceName);
        if (service != null) {
            return service.getPorts();
        }
        return Collections.emptyList();
    }

    public boolean contains(QName serviceName, QName portName) {
        WSDLServiceImpl service = this.wsdlDoc.getService(serviceName);
        if (service != null) {
            return service.get(portName) != null;
        }
        return false;
    }

    public QName getFirstServiceName() {
        return this.wsdlDoc.getFirstServiceName();
    }

    public Set<QName> getAllServiceNames() {
        return this.wsdlDoc.getServices().keySet();
    }
}

