/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.istack.NotNull;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.http.server.WSHttpHandler;
import com.sun.xml.ws.util.PropertySet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpExchange httpExchange;
    private int status;
    private int responseContentLength = 0;
    private boolean outputWritten;
    private static final PropertySet.PropertyMap model = ServerConnectionImpl.parse(ServerConnectionImpl.class);

    public ServerConnectionImpl(@NotNull HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.headers")
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    @Override
    public String getRequestHeader(String headerName) {
        return this.httpExchange.getRequestHeaders().getFirst(headerName);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> headers) {
        Headers r = this.httpExchange.getResponseHeaders();
        r.clear();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            if (name.equalsIgnoreCase("Content-Length")) {
                this.responseContentLength = Integer.parseInt(values.get(0));
                continue;
            }
            r.put(name, (List<String>)new ArrayList<String>(values));
        }
    }

    @PropertySet.Property(value="javax.xml.ws.http.response.headers")
    public Map<String, List<String>> getResponseHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    @Override
    public void setContentTypeResponseHeader(@NotNull String value) {
        this.httpExchange.getResponseHeaders().set("Content-Type", value);
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.response.code")
    public int getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public InputStream getInput() {
        return this.httpExchange.getRequestBody();
    }

    @Override
    @NotNull
    public OutputStream getOutput() throws IOException {
        assert (!this.outputWritten);
        this.outputWritten = true;
        this.httpExchange.sendResponseHeaders(this.getStatus(), this.responseContentLength);
        return this.httpExchange.getResponseBody();
    }

    @Override
    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @Override
    public Principal getUserPrincipal(Packet request) {
        return this.httpExchange.getPrincipal();
    }

    @Override
    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    @Override
    public String getEPRAddress(Packet request) {
        return WSHttpHandler.getRequestAddress(this.httpExchange);
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.method")
    @NotNull
    public String getRequestMethod() {
        return this.httpExchange.getRequestMethod();
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.querystring")
    public String getQueryString() {
        URI requestUri = this.httpExchange.getRequestURI();
        String query = requestUri.getQuery();
        if (query != null) {
            return query;
        }
        return null;
    }

    @Override
    @PropertySet.Property(value="javax.xml.ws.http.request.pathinfo")
    public String getPathInfo() {
        URI requestUri = this.httpExchange.getRequestURI();
        String reqPath = requestUri.getPath();
        String ctxtPath = this.httpExchange.getHttpContext().getPath();
        if (reqPath.length() > ctxtPath.length()) {
            return reqPath.substring(ctxtPath.length());
        }
        return null;
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

