/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.ExceptionHasMessage;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.resources.WsservletMessages;
import com.sun.xml.ws.transport.http.HttpAdapterList;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpAdapter
extends Adapter<HttpToolkit> {
    public final Map<String, SDDocument> wsdls;
    public final Map<SDDocument, String> revWsdls;
    public final HttpAdapterList<? extends HttpAdapter> owner;

    public static HttpAdapter createAlone(WSEndpoint endpoint) {
        return new DummyList().createAdapter("", "", endpoint);
    }

    protected HttpAdapter(WSEndpoint endpoint, HttpAdapterList<? extends HttpAdapter> owner) {
        super(endpoint);
        this.owner = owner;
        ServiceDefinition sdef = this.endpoint.getServiceDefinition();
        if (sdef == null) {
            this.wsdls = Collections.emptyMap();
            this.revWsdls = Collections.emptyMap();
        } else {
            this.wsdls = new HashMap<String, SDDocument>();
            TreeMap<String, SDDocument> systemIds = new TreeMap<String, SDDocument>();
            for (SDDocument sdd : sdef) {
                if (sdd == sdef.getPrimary()) {
                    this.wsdls.put("wsdl", sdd);
                    this.wsdls.put("WSDL", sdd);
                    continue;
                }
                systemIds.put(sdd.getURL().toString(), sdd);
            }
            int wsdlnum = 1;
            int xsdnum = 1;
            for (Map.Entry entry : systemIds.entrySet()) {
                SDDocument sdd = (SDDocument)entry.getValue();
                if (sdd.isWSDL()) {
                    this.wsdls.put("wsdl=" + wsdlnum++, sdd);
                }
                if (!sdd.isSchema()) continue;
                this.wsdls.put("xsd=" + xsdnum++, sdd);
            }
            this.revWsdls = new HashMap<SDDocument, String>();
            for (Map.Entry<Object, Object> entry : this.wsdls.entrySet()) {
                this.revWsdls.put((SDDocument)entry.getValue(), (String)entry.getKey());
            }
        }
    }

    @Override
    protected HttpToolkit createToolkit() {
        return new HttpToolkit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(@NotNull WSHTTPConnection connection) throws IOException {
        HttpToolkit tk = (HttpToolkit)this.pool.take();
        try {
            tk.handle(connection);
        }
        finally {
            this.pool.recycle(tk);
        }
    }

    public final boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    public void publishWSDL(WSHTTPConnection con, String baseAddress, String queryString) throws IOException {
        InputStream in = con.getInput();
        while (in.read() != -1) {
        }
        in.close();
        SDDocument doc = this.wsdls.get(queryString);
        if (doc == null) {
            this.writeNotFoundErrorPage(con, "Invalid Request");
            return;
        }
        con.setStatus(200);
        con.setContentTypeResponseHeader("text/xml");
        OutputStream os = con.getOutput();
        PortAddressResolver portAddressResolver = this.owner.createPortAddressResolver(baseAddress);
        final String address = portAddressResolver.getAddressFor(this.endpoint.getPort().getName().getLocalPart());
        assert (address != null);
        DocumentAddressResolver resolver = new DocumentAddressResolver(){

            public String getRelativeAddressFor(SDDocument current, SDDocument referenced) {
                assert (HttpAdapter.this.revWsdls.containsKey(referenced));
                return address + '?' + HttpAdapter.this.revWsdls.get(referenced);
            }
        };
        doc.writeTo(portAddressResolver, resolver, os);
        os.close();
    }

    private void writeNotFoundErrorPage(WSHTTPConnection con, String message) throws IOException {
        con.setStatus(404);
        con.setContentTypeResponseHeader("text/html; charset=UTF-8");
        PrintWriter out = new PrintWriter(new OutputStreamWriter(con.getOutput(), "UTF-8"));
        out.println("<html>");
        out.println("<head><title>");
        out.println(WsservletMessages.SERVLET_HTML_TITLE());
        out.println("</title></head>");
        out.println("<body>");
        out.println(WsservletMessages.SERVLET_HTML_NOT_FOUND(message));
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    private void writeInternalServerError(WSHTTPConnection con) throws IOException {
        con.setStatus(500);
        con.getOutput().close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyList
    extends HttpAdapterList<HttpAdapter> {
        private DummyList() {
        }

        @Override
        protected HttpAdapter createHttpAdapter(String name, String urlPattern, WSEndpoint<?> endpoint) {
            return new HttpAdapter(endpoint, this);
        }
    }

    final class HttpToolkit
    extends Adapter.Toolkit
    implements TransportBackChannel {
        private WSHTTPConnection con;
        private boolean closed;

        HttpToolkit() {
        }

        public void handle(WSHTTPConnection con) throws IOException {
            this.con = con;
            this.closed = false;
            String ct = con.getRequestHeader("Content-Type");
            InputStream in = con.getInput();
            Packet packet = new Packet();
            packet.acceptableMimeTypes = con.getRequestHeader("Accept");
            packet.addSatellite(con);
            try {
                this.codec.decode(in, ct, packet);
                try {
                    packet = this.head.process(packet, con.getWebServiceContextDelegate(), this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!this.closed) {
                        HttpAdapter.this.writeInternalServerError(con);
                    }
                    return;
                }
            }
            catch (ExceptionHasMessage e) {
                e.printStackTrace();
                packet.setMessage(e.getFaultMessage());
            }
            if (this.closed) {
                return;
            }
            Message responseMessage = packet.getMessage();
            if (responseMessage == null) {
                this.close();
            } else {
                ContentType contentType;
                if (con.getStatus() == 0) {
                    con.setStatus(responseMessage.isFault() ? 500 : 200);
                }
                if ((contentType = this.codec.getStaticContentType(packet)) != null) {
                    con.setContentTypeResponseHeader(contentType.getContentType());
                    OutputStream os = con.getOutput();
                    this.codec.encode(packet, os);
                    os.close();
                } else {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    contentType = this.codec.encode(packet, baos);
                    con.setContentTypeResponseHeader(contentType.getContentType());
                    OutputStream os = con.getOutput();
                    baos.writeTo(os);
                    os.close();
                }
            }
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.con.setStatus(202);
                try {
                    this.con.getOutput().close();
                }
                catch (IOException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
        }
    }
}

