/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.server.EndpointMessageContextImpl;
import com.sun.xml.ws.server.WSEndpointImpl;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvokerPipe<T>
extends AbstractTubeImpl {
    private final Invoker invoker;
    private WSEndpoint endpoint;
    private final ThreadLocal<Packet> packets = new ThreadLocal();
    private final WebServiceContext webServiceContext = new WebServiceContext(){

        public MessageContext getMessageContext() {
            return new EndpointMessageContextImpl(this.getCurrentPacket());
        }

        public Principal getUserPrincipal() {
            Packet packet = this.getCurrentPacket();
            return packet.webServiceContextDelegate.getUserPrincipal(packet);
        }

        private Packet getCurrentPacket() {
            Packet p = (Packet)InvokerPipe.this.packets.get();
            assert (p != null);
            return p;
        }

        public boolean isUserInRole(String role) {
            Packet packet = this.getCurrentPacket();
            return packet.webServiceContextDelegate.isUserInRole(packet, role);
        }

        public EndpointReference getEndpointReference() {
            return this.getEndpointReference(W3CEndpointReference.class);
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
            Packet packet = this.getCurrentPacket();
            String address = packet.webServiceContextDelegate.getEPRAddress(packet);
            return ((WSEndpointImpl)InvokerPipe.this.endpoint).getEndpointReference(clazz, address);
        }
    };

    protected InvokerPipe(Invoker invoker) {
        this.invoker = invoker;
        invoker.start(this.webServiceContext);
    }

    public void setEndpoint(WSEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @NotNull
    public final Invoker getInvoker(Packet request) {
        this.packets.set(request);
        return this.invoker;
    }

    @Override
    public final AbstractTubeImpl copy(TubeCloner cloner) {
        cloner.add(this, this);
        return this;
    }

    @Override
    public void preDestroy() {
        this.invoker.dispose();
    }

    @Override
    public NextAction processRequest(Packet request) {
        Packet res = this.process(request);
        return this.doReturnWith(res);
    }

    @Override
    public NextAction processResponse(Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @Override
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

