/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.soap;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import com.sun.xml.ws.protocol.soap.MUPipe;
import java.util.Set;
import javax.xml.namespace.QName;

public class ClientMUPipe
extends MUPipe {
    private Pipe next;

    public ClientMUPipe(WSBinding binding, Pipe next) {
        super(binding, next);
        this.next = next;
    }

    public ClientMUPipe(WSBinding binding, Tube next) {
        super(binding, next);
    }

    protected ClientMUPipe(ClientMUPipe that, TubeCloner cloner) {
        super(that, cloner);
        this.next = ((PipeCloner)cloner).copy(that.next);
    }

    public Packet process(Packet packet) {
        Packet reply = this.next.process(packet);
        if (reply.getMessage() == null) {
            return reply;
        }
        HandlerConfiguration handlerConfig = packet.handlerConfig;
        Set<QName> misUnderstoodHeaders = this.getMisUnderstoodHeaders(reply.getMessage().getHeaders(), handlerConfig.getRoles(), handlerConfig.getKnownHeaders());
        if (misUnderstoodHeaders == null || misUnderstoodHeaders.isEmpty()) {
            return reply;
        }
        throw this.createMUSOAPFaultException(misUnderstoodHeaders);
    }

    public NextAction processRequest(Packet request) {
        return super.processRequest(request);
    }

    public NextAction processResponse(Packet response) {
        HandlerConfiguration handlerConfig = response.handlerConfig;
        Set<QName> misUnderstoodHeaders = this.getMisUnderstoodHeaders(response.getMessage().getHeaders(), handlerConfig.getRoles(), handlerConfig.getKnownHeaders());
        if (misUnderstoodHeaders == null || misUnderstoodHeaders.isEmpty()) {
            return super.processResponse(response);
        }
        throw this.createMUSOAPFaultException(misUnderstoodHeaders);
    }

    public AbstractTubeImpl copy(TubeCloner cloner) {
        return new ClientMUPipe(this, cloner);
    }
}

