/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.ws.message.AbstractHeaderImpl;
import com.sun.xml.ws.util.exception.XMLStreamException2;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class StringHeader
extends AbstractHeaderImpl {
    protected final QName name;
    protected final String value;

    public StringHeader(QName name, String value) {
        assert (name != null);
        this.name = name;
        this.value = value;
    }

    @NotNull
    public String getNamespaceURI() {
        return this.name.getNamespaceURI();
    }

    @NotNull
    public String getLocalPart() {
        return this.name.getLocalPart();
    }

    @Nullable
    public String getAttribute(@NotNull String nsUri, @NotNull String localName) {
        return this.getAttribute(this.name.getNamespaceURI(), this.name.getLocalPart());
    }

    public XMLStreamReader readHeader() throws XMLStreamException {
        try {
            MutableXMLStreamBuffer buf = new MutableXMLStreamBuffer();
            XMLStreamWriter w = buf.createFromXMLStreamWriter();
            this.writeTo(w);
            return buf.readAsXMLStreamReader();
        }
        catch (XMLStreamBufferException e) {
            throw new XMLStreamException2(e);
        }
    }

    public void writeTo(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement("", this.name.getLocalPart(), this.name.getNamespaceURI());
        w.writeDefaultNamespace(this.name.getNamespaceURI());
        w.writeCharacters(this.value);
        w.writeEndElement();
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        SOAPHeader header = saaj.getSOAPHeader();
        SOAPHeaderElement she = header.addHeaderElement(this.name);
        she.addTextNode(this.value);
    }

    public void writeTo(ContentHandler h, ErrorHandler errorHandler) throws SAXException {
        String nsUri = this.name.getNamespaceURI();
        String ln = this.name.getLocalPart();
        h.startPrefixMapping("", nsUri);
        h.startElement(nsUri, ln, ln, EMPTY_ATTS);
        h.characters(this.value.toCharArray(), 0, this.value.length());
        h.endElement(nsUri, ln, ln);
    }
}

