/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.message;

import com.sun.istack.NotNull;
import com.sun.xml.messaging.saaj.soap.AttachmentPartImpl;
import com.sun.xml.ws.api.message.Attachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class DataHandlerAttachment
implements Attachment {
    private final DataHandler dh;
    private final String contentId;

    public DataHandlerAttachment(@NotNull String contentId, @NotNull DataHandler dh) {
        this.dh = dh;
        this.contentId = contentId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.dh.getContentType();
    }

    public byte[] asByteArray() {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(1024);
        try {
            InputStream is = this.dh.getDataSource().getInputStream();
            baos.readFrom(is);
            is.close();
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
        return baos.getBuffer();
    }

    public DataHandler asDataHandler() {
        return this.dh;
    }

    public Source asSource() {
        try {
            return new StreamSource(this.dh.getInputStream());
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public InputStream asInputStream() {
        try {
            return this.dh.getInputStream();
        }
        catch (IOException e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.asByteArray());
    }

    public void writeTo(SOAPMessage saaj) throws SOAPException {
        AttachmentPart part = saaj.createAttachmentPart();
        part.setDataHandler(this.dh);
        part.setContentId(this.contentId);
        saaj.addAttachmentPart(part);
    }

    static {
        new AttachmentPartImpl();
    }

    private final class ByteArrayOutputStreamEx
    extends ByteArrayOutputStream {
        public ByteArrayOutputStreamEx() {
        }

        public ByteArrayOutputStreamEx(int size) {
            super(size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }

        public void readFrom(InputStream is) throws IOException {
            while (true) {
                int sz;
                if (this.count == this.buf.length) {
                    byte[] data = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, data, 0, this.buf.length);
                    this.buf = data;
                }
                if ((sz = is.read(this.buf, this.count, this.buf.length - this.count)) < 0) {
                    return;
                }
                this.count += sz;
            }
        }
    }
}

