/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.handler.HandlerPipe;
import com.sun.xml.ws.handler.HandlerProcessor;
import com.sun.xml.ws.handler.LogicalMessageContextImpl;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import com.sun.xml.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.ws.handler.XMLHandlerProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.MessageContext;

public class ServerLogicalHandlerPipe
extends HandlerPipe {
    private WSBinding binding;
    private List<LogicalHandler> logicalHandlers;

    public ServerLogicalHandlerPipe(WSBinding binding, WSDLPort port, Pipe next) {
        super(next, port);
        this.binding = binding;
        this.setUpProcessorOnce();
    }

    public ServerLogicalHandlerPipe(WSBinding binding, Pipe next, HandlerPipe cousinPipe) {
        super(next, cousinPipe);
        this.binding = binding;
        this.setUpProcessorOnce();
    }

    private ServerLogicalHandlerPipe(ServerLogicalHandlerPipe that, TubeCloner cloner) {
        super(that, cloner);
        this.binding = that.binding;
        this.setUpProcessorOnce();
    }

    boolean isHandlerChainEmpty() {
        return this.logicalHandlers.isEmpty();
    }

    public void close(MessageContext msgContext) {
        if (this.binding.getSOAPVersion() == null && this.processor != null) {
            this.closeLogicalHandlers(msgContext);
        }
    }

    public void closeCall(MessageContext msgContext) {
        this.closeLogicalHandlers(msgContext);
    }

    private void closeLogicalHandlers(MessageContext msgContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(msgContext, this.processor.getIndex(), this.logicalHandlers.size() - 1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(msgContext, 0, this.logicalHandlers.size() - 1);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner cloner) {
        return new ServerLogicalHandlerPipe(this, cloner);
    }

    private void setUpProcessorOnce() {
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        List<LogicalHandler> logicalSnapShot = ((BindingImpl)this.binding).getHandlerConfig().getLogicalHandlers();
        if (!logicalSnapShot.isEmpty()) {
            this.logicalHandlers.addAll(logicalSnapShot);
            this.processor = this.binding.getSOAPVersion() == null ? new XMLHandlerProcessor(this, this.binding, this.logicalHandlers) : new SOAPHandlerProcessor(false, this, this.binding, this.logicalHandlers);
        }
    }

    void setUpProcessor() {
    }

    MessageUpdatableContext getContext(Packet packet) {
        return new LogicalMessageContextImpl(this.binding, packet);
    }

    boolean callHandlersOnRequest(MessageUpdatableContext context, boolean isOneWay) {
        boolean handlerResult;
        try {
            handlerResult = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, context, !isOneWay);
        }
        catch (WebServiceException wse) {
            this.remedyActionTaken = true;
            throw wse;
        }
        catch (RuntimeException re) {
            this.remedyActionTaken = true;
            throw re;
        }
        if (!handlerResult) {
            this.remedyActionTaken = true;
        }
        return handlerResult;
    }

    void callHandlersOnResponse(MessageUpdatableContext context, boolean handleFault) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, context, handleFault);
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (RuntimeException re) {
            throw re;
        }
    }
}

