/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.istack.Nullable;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.pipe.PipeCloner;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.ws.handler.HandlerProcessor;
import com.sun.xml.ws.handler.MessageUpdatableContext;
import javax.xml.ws.handler.MessageContext;

public abstract class HandlerPipe
extends AbstractFilterTubeImpl {
    HandlerPipe cousinPipe;
    HandlerProcessor processor;
    boolean remedyActionTaken = false;
    @Nullable
    private final WSDLPort port;
    boolean requestProcessingSucessful = false;
    Pipe next;
    private HandlerPipeExchange exchange;

    public HandlerPipe(Pipe next, WSDLPort port) {
        super(PipeAdapter.adapt(next));
        this.port = port;
        this.next = next;
    }

    public HandlerPipe(Pipe next, HandlerPipe cousinPipe) {
        super(PipeAdapter.adapt(next));
        this.cousinPipe = cousinPipe;
        this.port = cousinPipe != null ? cousinPipe.port : null;
        this.next = next;
    }

    protected HandlerPipe(HandlerPipe that, TubeCloner cloner) {
        super(that, cloner);
        if (that.cousinPipe != null) {
            this.cousinPipe = cloner.copy(that.cousinPipe);
        }
        this.port = that.port;
        this.next = ((PipeCloner)cloner).copy(that.next);
    }

    public NextAction processRequest(Packet request) {
        return this.doInvoke(((AbstractFilterTubeImpl)this).next, request);
    }

    public NextAction processResponse(Packet response) {
        return this.doReturnWith(response);
    }

    public void preDestroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Packet process(Packet packet) {
        Packet reply;
        this.setupExchange();
        if (this.isHandleFalse()) {
            this.remedyActionTaken = true;
            return this.next.process(packet);
        }
        this.setUpProcessor();
        MessageUpdatableContext context = this.getContext(packet);
        try {
            boolean isOneWay = this.checkOneWay(packet);
            if (!this.isHandlerChainEmpty()) {
                boolean handlerResult = this.callHandlersOnRequest(context, isOneWay);
                context.updatePacket();
                if (!isOneWay && !handlerResult) {
                    Packet packet2 = packet;
                    return packet2;
                }
            }
            this.requestProcessingSucessful = true;
            reply = this.next.process(packet);
            context = this.getContext(reply);
            if (this.isHandleFalse() || reply.getMessage() == null) {
                Packet handlerResult = reply;
                return handlerResult;
            }
            boolean isFault = this.isHandleFault(reply);
            if (!this.isHandlerChainEmpty()) {
                this.callHandlersOnResponse(context, isFault);
            }
        }
        finally {
            this.exchange = null;
            this.close(context.getMessageContext());
            this.requestProcessingSucessful = false;
        }
        context.updatePacket();
        return reply;
    }

    abstract void callHandlersOnResponse(MessageUpdatableContext var1, boolean var2);

    abstract boolean callHandlersOnRequest(MessageUpdatableContext var1, boolean var2);

    private boolean checkOneWay(Packet packet) {
        if (this.port != null) {
            return packet.getMessage().isOneWay(this.port);
        }
        return packet.expectReply != null && packet.expectReply != false;
    }

    abstract void setUpProcessor();

    abstract boolean isHandlerChainEmpty();

    abstract MessageUpdatableContext getContext(Packet var1);

    protected abstract void close(MessageContext var1);

    protected abstract void closeCall(MessageContext var1);

    private boolean isHandleFault(Packet packet) {
        if (this.cousinPipe != null) {
            return this.exchange.isHandleFault();
        }
        boolean isFault = packet.getMessage().isFault();
        this.exchange.setHandleFault(isFault);
        return isFault;
    }

    final void setHandleFault() {
        this.exchange.setHandleFault(true);
    }

    private boolean isHandleFalse() {
        return this.exchange.isHandleFalse();
    }

    final void setHandleFalse() {
        this.exchange.setHandleFalse();
    }

    private void setupExchange() {
        if (this.exchange == null) {
            this.exchange = new HandlerPipeExchange();
            if (this.cousinPipe != null) {
                this.cousinPipe.exchange = this.exchange;
            }
        }
    }

    static final class HandlerPipeExchange {
        private boolean handleFalse;
        private boolean handleFault;

        HandlerPipeExchange() {
        }

        boolean isHandleFault() {
            return this.handleFault;
        }

        void setHandleFault(boolean isFault) {
            this.handleFault = isFault;
        }

        public boolean isHandleFalse() {
            return this.handleFalse;
        }

        void setHandleFalse() {
            this.handleFalse = true;
        }
    }
}

