/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.stream.buffer.AbstractCreatorProcessor;
import com.sun.xml.stream.buffer.MutableXMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferException;
import com.sun.xml.stream.buffer.XMLStreamBufferMark;
import com.sun.xml.stream.buffer.stax.StreamReaderBufferCreator;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.StreamSOAP11Codec;
import com.sun.xml.ws.encoding.StreamSOAP12Codec;
import com.sun.xml.ws.encoding.TagInfoset;
import com.sun.xml.ws.message.AttachmentSetImpl;
import com.sun.xml.ws.message.stream.StreamHeader;
import com.sun.xml.ws.message.stream.StreamMessage;
import com.sun.xml.ws.protocol.soap.VersionMismatchException;
import com.sun.xml.ws.streaming.XMLStreamReaderFactory;
import com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.ws.streaming.XMLStreamWriterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamSOAPCodec
implements Codec {
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private final String SOAP_NAMESPACE_URI;
    private final SOAPVersion soapVersion;

    StreamSOAPCodec(SOAPVersion soapVersion) {
        this.SOAP_NAMESPACE_URI = soapVersion.nsUri;
        this.soapVersion = soapVersion;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        return this.getContentType(packet.soapAction);
    }

    @Override
    public ContentType encode(Packet packet, OutputStream out) {
        if (packet.getMessage() != null) {
            XMLStreamWriter writer = XMLStreamWriterFactory.createXMLStreamWriter(out);
            try {
                packet.getMessage().writeTo(writer);
                writer.flush();
            }
            catch (XMLStreamException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        return this.getContentType(packet.soapAction);
    }

    protected abstract ContentType getContentType(String var1);

    @Override
    public ContentType encode(Packet packet, WritableByteChannel buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        XMLStreamReader reader = this.createXMLStreamReader(in);
        packet.setMessage(this.decode(reader));
    }

    public final Message decode(XMLStreamReader reader) {
        if (reader.getEventType() != 1) {
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        if (SOAP_ENVELOPE.equals(reader.getLocalName()) && !this.SOAP_NAMESPACE_URI.equals(reader.getNamespaceURI())) {
            throw new VersionMismatchException(this.soapVersion, this.SOAP_NAMESPACE_URI, reader.getNamespaceURI());
        }
        XMLStreamReaderUtil.verifyTag(reader, this.SOAP_NAMESPACE_URI, SOAP_ENVELOPE);
        TagInfoset envelopeTag = new TagInfoset(reader);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        XMLStreamReaderUtil.nextElementContent(reader);
        XMLStreamReaderUtil.verifyReaderState(reader, 1);
        HeaderList headers = null;
        TagInfoset headerTag = null;
        if (reader.getLocalName().equals(SOAP_HEADER) && reader.getNamespaceURI().equals(this.SOAP_NAMESPACE_URI)) {
            headerTag = new TagInfoset(reader);
            for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                namespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
            }
            XMLStreamReaderUtil.nextElementContent(reader);
            if (reader.getEventType() == 1) {
                headers = new HeaderList();
                try {
                    this.cacheHeaders(reader, namespaces, headers);
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException((Throwable)e);
                }
                catch (XMLStreamBufferException e) {
                    throw new WebServiceException((Throwable)e);
                }
            }
            XMLStreamReaderUtil.nextElementContent(reader);
        }
        XMLStreamReaderUtil.verifyTag(reader, this.SOAP_NAMESPACE_URI, SOAP_BODY);
        TagInfoset bodyTag = new TagInfoset(reader);
        XMLStreamReaderUtil.nextElementContent(reader);
        return new StreamMessage(envelopeTag, headerTag, new AttachmentSetImpl(), headers, bodyTag, reader, this.soapVersion);
    }

    @Override
    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final StreamSOAPCodec copy() {
        return this;
    }

    private XMLStreamBuffer cacheHeaders(XMLStreamReader reader, Map<String, String> namespaces, HeaderList headers) throws XMLStreamException, XMLStreamBufferException {
        MutableXMLStreamBuffer buffer = this.createXMLStreamBuffer();
        StreamReaderBufferCreator creator = new StreamReaderBufferCreator();
        creator.setXMLStreamBuffer(buffer);
        while (reader.getEventType() == 1) {
            Map<String, String> headerBlockNamespaces = namespaces;
            if (reader.getNamespaceCount() > 0) {
                headerBlockNamespaces = new HashMap<String, String>(namespaces);
                for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                    headerBlockNamespaces.put(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                }
            }
            XMLStreamBufferMark mark = new XMLStreamBufferMark(headerBlockNamespaces, (AbstractCreatorProcessor)creator);
            headers.add(this.createHeader(reader, (XMLStreamBuffer)mark));
            creator.createElementFragment(reader, false);
        }
        return buffer;
    }

    protected abstract StreamHeader createHeader(XMLStreamReader var1, XMLStreamBuffer var2);

    protected XMLStreamReader createXMLStreamReader(InputStream in) {
        return XMLStreamReaderFactory.createXMLStreamReader(in, true);
    }

    private MutableXMLStreamBuffer createXMLStreamBuffer() {
        return new MutableXMLStreamBuffer();
    }

    public static StreamSOAPCodec create(SOAPVersion version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        switch (version) {
            case SOAP_11: {
                return new StreamSOAP11Codec();
            }
            case SOAP_12: {
                return new StreamSOAP12Codec();
            }
        }
        throw new AssertionError();
    }
}

