/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.encoding;

import com.sun.xml.messaging.saaj.packaging.mime.util.OutputUtil;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.encoding.ContentTypeImpl;
import com.sun.xml.ws.encoding.MimeMultipartParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.UUID;

abstract class MimeCodec
implements Codec {
    public static final String MULTIPART_RELATED_MIME_TYPE = "multipart/related";
    private String boundary;
    private String messageContentType;
    private boolean hasAttachments;
    protected Codec rootCodec;
    protected final SOAPVersion version;

    protected MimeCodec(SOAPVersion version) {
        this.version = version;
    }

    public String getMimeType() {
        return MULTIPART_RELATED_MIME_TYPE;
    }

    public ContentType encode(Packet packet, OutputStream out) throws IOException {
        Message msg = packet.getMessage();
        if (msg == null) {
            return null;
        }
        if (this.hasAttachments) {
            OutputUtil.writeln((String)("--" + this.boundary), (OutputStream)out);
            OutputUtil.writeln((String)("Content-Type: " + this.rootCodec.getMimeType()), (OutputStream)out);
            OutputUtil.writeln((OutputStream)out);
        }
        ContentType primaryCt = this.rootCodec.encode(packet, out);
        if (this.hasAttachments) {
            OutputUtil.writeln((OutputStream)out);
            for (Attachment att : msg.getAttachments()) {
                OutputUtil.writeln((String)("--" + this.boundary), (OutputStream)out);
                String cid = att.getContentId();
                if (cid != null && cid.length() > 0 && cid.charAt(0) != '<') {
                    cid = '<' + cid + '>';
                }
                OutputUtil.writeln((String)("Content-Id:" + cid), (OutputStream)out);
                OutputUtil.writeln((String)("Content-Type: " + att.getContentType()), (OutputStream)out);
                OutputUtil.writeln((String)"Content-Transfer-Encoding: binary", (OutputStream)out);
                OutputUtil.writeln((OutputStream)out);
                att.writeTo(out);
                OutputUtil.writeln((OutputStream)out);
            }
            OutputUtil.writeAsAscii((String)("--" + this.boundary), (OutputStream)out);
            OutputUtil.writeAsAscii((String)"--", (OutputStream)out);
        }
        return this.hasAttachments ? new ContentTypeImpl(this.messageContentType, packet.soapAction, null) : primaryCt;
    }

    public ContentType getStaticContentType(Packet packet) {
        Message msg = packet.getMessage();
        boolean bl = this.hasAttachments = !msg.getAttachments().isEmpty();
        if (this.hasAttachments) {
            this.boundary = "uuid:" + UUID.randomUUID().toString();
            String boundaryParameter = "boundary=\"" + this.boundary + "\"";
            this.messageContentType = "multipart/related; type=\"" + this.rootCodec.getMimeType() + "\"; " + boundaryParameter;
            return new ContentTypeImpl(this.messageContentType, packet.soapAction, null);
        }
        return this.rootCodec.getStaticContentType(packet);
    }

    protected MimeCodec(MimeCodec that) {
        this.version = that.version;
    }

    public void decode(InputStream in, String contentType, Packet packet) throws IOException {
        MimeMultipartParser parser = new MimeMultipartParser(in, contentType);
        this.decode(parser, packet);
    }

    public void decode(ReadableByteChannel in, String contentType, Packet packet) {
        throw new UnsupportedOperationException();
    }

    protected abstract void decode(MimeMultipartParser var1, Packet var2) throws IOException;

    public abstract MimeCodec copy();
}

