/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.istack.NotNull;
import com.sun.xml.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.MEP;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.sei.AsyncMethodHandler;
import com.sun.xml.ws.client.sei.CallbackMethodHandler;
import com.sun.xml.ws.client.sei.MethodHandler;
import com.sun.xml.ws.client.sei.PollingMethodHandler;
import com.sun.xml.ws.client.sei.SyncMethodHandler;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.SOAPSEIModel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.spi.ServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SEIStub
extends Stub
implements InvocationHandler {
    public final SOAPSEIModel seiModel;
    public final SOAPVersion soapVersion;
    public final ServiceDelegate owner;
    private final Map<Method, MethodHandler> methodHandlers = new HashMap<Method, MethodHandler>();

    public SEIStub(ServiceDelegate owner, BindingImpl binding, SOAPSEIModel seiModel, Pipe master) {
        super(master, binding, seiModel.getPort(), seiModel.getPort().getAddress());
        this.owner = owner;
        this.seiModel = seiModel;
        this.soapVersion = binding.getSOAPVersion();
        HashMap<WSDLBoundOperation, SyncMethodHandler> syncs = new HashMap<WSDLBoundOperation, SyncMethodHandler>();
        for (JavaMethodImpl m : seiModel.getJavaMethods()) {
            if (m.getMEP().isAsync) continue;
            SyncMethodHandler handler = new SyncMethodHandler(this, m);
            syncs.put(m.getOperation(), handler);
            this.methodHandlers.put(m.getMethod(), handler);
        }
        for (JavaMethodImpl jm : seiModel.getJavaMethods()) {
            AsyncMethodHandler handler;
            Method m;
            SyncMethodHandler sync = (SyncMethodHandler)syncs.get(jm.getOperation());
            if (jm.getMEP() == MEP.ASYNC_CALLBACK) {
                m = jm.getMethod();
                handler = new CallbackMethodHandler(this, jm, sync, m.getParameterTypes().length - 1);
                this.methodHandlers.put(m, handler);
            }
            if (jm.getMEP() != MEP.ASYNC_POLL) continue;
            m = jm.getMethod();
            handler = new PollingMethodHandler(this, jm, sync);
            this.methodHandlers.put(m, handler);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws WebServiceException, Throwable {
        MethodHandler handler = this.methodHandlers.get(method);
        if (handler != null) {
            return handler.invoke(proxy, args);
        }
        try {
            return method.invoke((Object)this, args);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public final Packet doProcess(Packet request, RequestContext rc, ResponseContextReceiver receiver) {
        return super.process(request, rc, receiver);
    }

    protected final Executor getExecutor() {
        return this.owner.getExecutor();
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        if (this.endpointReference != null) {
            return EndpointReferenceUtil.transform(clazz, this.endpointReference);
        }
        WSDLPort port = this.seiModel.getPort();
        assert (port != null);
        this.endpointReference = EndpointReferenceUtil.getEndpointReference(clazz, port.getAddress().toString(), this.owner.getServiceName(), this.getPortName(port).getLocalPart(), this.getPortTypeName(port), true);
        return (T)this.endpointReference;
    }

    private QName getPortName(@NotNull WSDLPort wsdlport) {
        return wsdlport.getName();
    }

    private QName getPortTypeName(@NotNull WSDLPort wsdlport) {
        return wsdlport.getBinding().getPortTypeName();
    }
}

