/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.sei;

import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.ResponseImpl;
import com.sun.xml.ws.client.sei.AsyncBuilder;
import com.sun.xml.ws.client.sei.MethodHandler;
import com.sun.xml.ws.client.sei.SEIStub;
import com.sun.xml.ws.client.sei.SyncMethodHandler;
import com.sun.xml.ws.client.sei.ValueGetter;
import com.sun.xml.ws.model.JavaMethodImpl;
import com.sun.xml.ws.model.ParameterImpl;
import com.sun.xml.ws.model.WrapperParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AsyncMethodHandler
extends MethodHandler {
    private final JavaMethodImpl jm;
    private final AsyncBuilder asyncBuilder;
    private final SyncMethodHandler core;

    protected AsyncMethodHandler(SEIStub owner, JavaMethodImpl jm, SyncMethodHandler core) {
        super(owner);
        this.jm = jm;
        this.core = core;
        List<ParameterImpl> rp = jm.getResponseParameters();
        Class tempWrap = null;
        for (ParameterImpl param : rp) {
            if (param.isWrapperStyle()) {
                WrapperParameter wrapParam = (WrapperParameter)param;
                if (core.getJavaMethod().getBinding().getStyle() == SOAPBinding.Style.DOCUMENT) {
                    tempWrap = (Class)wrapParam.getTypeReference().type;
                    break;
                }
                for (ParameterImpl p : wrapParam.getWrapperChildren()) {
                    if (p.getIndex() != -1) continue;
                    tempWrap = (Class)p.getTypeReference().type;
                    break;
                }
                if (tempWrap == null) continue;
                break;
            }
            if (param.getIndex() != -1) continue;
            tempWrap = (Class)param.getTypeReference().type;
            break;
        }
        Class wrapper = tempWrap;
        rp = core.getJavaMethod().getResponseParameters();
        int size = 0;
        for (ParameterImpl param : rp) {
            if (param.isWrapperStyle()) {
                WrapperParameter wrapParam = (WrapperParameter)param;
                size += wrapParam.getWrapperChildren().size();
                if (core.getJavaMethod().getBinding().getStyle() != SOAPBinding.Style.DOCUMENT) continue;
                size += 2;
                continue;
            }
            ++size;
        }
        ArrayList<AsyncBuilder> builders = new ArrayList<AsyncBuilder>();
        if (size != 0) {
            if (size == 1) {
                ParameterImpl single = null;
                for (ParameterImpl param : rp) {
                    if (param.isWrapperStyle()) {
                        WrapperParameter wrapParam = (WrapperParameter)param;
                        Iterator<ParameterImpl> i$ = wrapParam.getWrapperChildren().iterator();
                        if (i$.hasNext()) {
                            ParameterImpl p;
                            single = p = i$.next();
                        }
                        if (single == null) continue;
                        break;
                    }
                    single = param;
                    break;
                }
                assert (single != null);
                builders.add(new AsyncBuilder.Filler(single));
            } else {
                block14: for (ParameterImpl param : rp) {
                    ValueGetter setter = ValueGetter.get(param);
                    switch (param.getOutBinding().kind) {
                        case BODY: {
                            if (param.isWrapperStyle()) {
                                if (param.getParent().getBinding().isRpcLit()) {
                                    builders.add(new AsyncBuilder.DocLit(wrapper, (WrapperParameter)param));
                                    continue block14;
                                }
                                builders.add(new AsyncBuilder.DocLit(wrapper, (WrapperParameter)param));
                                continue block14;
                            }
                            builders.add(new AsyncBuilder.Bare(wrapper, param));
                            continue block14;
                        }
                        case HEADER: {
                            builders.add(new AsyncBuilder.Bare(wrapper, param));
                            continue block14;
                        }
                        case ATTACHMENT: {
                            builders.add(new AsyncBuilder.Bare(wrapper, param));
                            continue block14;
                        }
                        case UNBOUND: {
                            continue block14;
                        }
                    }
                    throw new AssertionError();
                }
            }
        }
        switch (size) {
            case 0: {
                this.asyncBuilder = AsyncBuilder.NONE;
                break;
            }
            case 1: {
                this.asyncBuilder = (AsyncBuilder)builders.get(0);
                break;
            }
            default: {
                this.asyncBuilder = new AsyncBuilder.Composite(builders, wrapper);
            }
        }
    }

    protected final Response<Object> doInvoke(Object proxy, Object[] args, AsyncHandler handler) {
        Invoker invoker = new Invoker(proxy, args);
        ResponseImpl<Object> ft = new ResponseImpl<Object>(invoker, handler);
        invoker.setReceiver(ft);
        this.owner.getExecutor().execute(ft);
        return ft;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invoker
    implements Callable<Object> {
        private final Object proxy;
        private final Object[] args;
        private final RequestContext snapshot;
        private ResponseContextReceiver receiver;

        public Invoker(Object proxy, Object[] args) {
            this.snapshot = AsyncMethodHandler.this.owner.requestContext.copy();
            this.proxy = proxy;
            this.args = args;
        }

        @Override
        public Object call() throws Exception {
            assert (this.receiver != null);
            try {
                Method method = AsyncMethodHandler.this.core.getJavaMethod().getMethod();
                int noOfArgs = method.getParameterTypes().length;
                Object[] newArgs = new Object[noOfArgs];
                for (int i = 0; i < noOfArgs; ++i) {
                    if (method.getParameterTypes()[i].isAssignableFrom(Holder.class)) {
                        Holder holder = new Holder();
                        if (i < this.args.length) {
                            holder.value = this.args[i];
                        }
                        newArgs[i] = holder;
                        continue;
                    }
                    newArgs[i] = this.args[i];
                }
                Object returnValue = AsyncMethodHandler.this.core.invoke(this.proxy, newArgs, this.snapshot, this.receiver);
                return AsyncMethodHandler.this.asyncBuilder.fillAsyncBean(newArgs, returnValue, null);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    if (t instanceof WebServiceException) {
                        throw (WebServiceException)t;
                    }
                } else if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new WebServiceException(t);
            }
        }

        void setReceiver(ResponseContextReceiver receiver) {
            this.receiver = receiver;
        }
    }
}

