/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDispatch
extends DispatchImpl<Source> {
    public SourceDispatch(QName port, Class<Source> aClass, Service.Mode mode, WSServiceDelegate owner, Pipe pipe, BindingImpl binding) {
        super(port, aClass, mode, owner, pipe, binding);
    }

    @Override
    Source toReturnValue(Packet response) {
        Message msg = response.getMessage();
        switch (this.mode) {
            case PAYLOAD: {
                return msg.readPayloadAsSource();
            }
            case MESSAGE: {
                return msg.readEnvelopeAsSource();
            }
        }
        throw new WebServiceException("Unrecognized dispatch mode");
    }

    @Override
    Packet createPacket(Source msg) {
        Message message;
        switch (this.mode) {
            case PAYLOAD: {
                message = msg == null ? Messages.createEmpty(this.soapVersion) : Messages.createUsingPayload(msg, this.soapVersion);
                break;
            }
            case MESSAGE: {
                if (SourceDispatch.isXMLHttp(this.binding)) {
                    message = msg == null ? Messages.createEmpty(this.soapVersion) : Messages.createUsingPayload(msg, this.soapVersion);
                    break;
                }
                message = Messages.create(msg, this.soapVersion);
                break;
            }
            default: {
                throw new WebServiceException("Unrecognized message mode");
            }
        }
        return new Packet(message);
    }
}

