/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.addressing.EndpointReferenceUtil;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.PortInfo;
import com.sun.xml.ws.client.RequestContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.client.ResponseImpl;
import com.sun.xml.ws.client.Stub;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.encoding.soap.DeserializationException;
import com.sun.xml.ws.fault.SOAPFaultBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DispatchImpl<T>
extends Stub
implements Dispatch<T> {
    final Service.Mode mode;
    final QName portname;
    Class<T> clazz;
    final WSServiceDelegate owner;
    final SOAPVersion soapVersion;
    static final long AWAIT_TERMINATION_TIME = 800L;

    protected DispatchImpl(QName port, Class<T> aClass, Service.Mode mode, WSServiceDelegate owner, Pipe pipe, BindingImpl binding) {
        this(port, mode, owner, pipe, binding);
        this.clazz = aClass;
    }

    protected DispatchImpl(QName port, Service.Mode mode, WSServiceDelegate owner, Pipe pipe, BindingImpl binding) {
        super(pipe, binding, null, owner.getEndpointAddress(port));
        this.portname = port;
        this.mode = mode;
        this.owner = owner;
        this.soapVersion = binding.getSOAPVersion();
    }

    abstract Packet createPacket(T var1);

    abstract T toReturnValue(Packet var1);

    public final Response<T> invokeAsync(T param) {
        Invoker invoker = new Invoker(param);
        ResponseImpl ft = new ResponseImpl(invoker, null);
        invoker.setReceiver(ft);
        this.owner.getExecutor().execute(ft);
        return ft;
    }

    public final Future<?> invokeAsync(T param, AsyncHandler<T> asyncHandler) {
        Invoker invoker = new Invoker(param);
        ResponseImpl<T> ft = new ResponseImpl<T>(invoker, asyncHandler);
        invoker.setReceiver(ft);
        ExecutorService exec = (ExecutorService)this.owner.getExecutor();
        try {
            exec.awaitTermination(800L, TimeUnit.MICROSECONDS);
        }
        catch (InterruptedException e) {
            throw new WebServiceException((Throwable)e);
        }
        exec.execute(ft);
        return ft;
    }

    public final T doInvoke(T in, RequestContext rc, ResponseContextReceiver receiver) {
        Packet response = null;
        try {
            DispatchImpl.checkNullAllowed(in, rc, this.binding, this.mode);
            Packet message = this.createPacket(in);
            this.setProperties(message, true);
            response = this.process(message, rc, receiver);
            Message msg = response.getMessage();
            if (msg != null && msg.isFault()) {
                SOAPFaultBuilder faultBuilder = SOAPFaultBuilder.create(msg);
                throw (SOAPFaultException)faultBuilder.createException(null, msg);
            }
        }
        catch (JAXBException e) {
            throw new DeserializationException("failed.to.read.response", new Object[]{e});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WebServiceException(e);
        }
        return this.toReturnValue(response);
    }

    public final T invoke(T in) {
        return this.doInvoke(in, this.requestContext, this);
    }

    public final void invokeOneWay(T in) {
        DispatchImpl.checkNullAllowed(in, this.requestContext, this.binding, this.mode);
        Packet request = this.createPacket(in);
        this.setProperties(request, false);
        Packet response = this.process(request, this.requestContext, this);
    }

    void setProperties(Packet packet, boolean expectReply) {
        packet.expectReply = expectReply;
    }

    static boolean isXMLHttp(WSBinding binding) {
        return binding.getBindingId().equals(BindingID.XML_HTTP);
    }

    static boolean isPAYLOADMode(Service.Mode mode) {
        return mode == Service.Mode.PAYLOAD;
    }

    static void checkNullAllowed(Object in, RequestContext rc, WSBinding binding, Service.Mode mode) {
        if (in != null) {
            return;
        }
        if (DispatchImpl.isXMLHttp(binding)) {
            if (DispatchImpl.methodNotOk(rc)) {
                throw new WebServiceException("A XML/HTTP request using MessageContext.HTTP_REQUEST_METHOD equals \"POST\" with a Null invocation Argument is not allowed");
            }
        } else if (mode == Service.Mode.MESSAGE) {
            throw new WebServiceException("SOAP/HTTP Binding in Service.Mode.message is not allowed with a null invocation argument");
        }
    }

    static boolean methodNotOk(RequestContext rc) {
        String requestMethod = (String)rc.get("javax.xml.ws.http.request.method");
        String request = requestMethod == null ? "POST" : requestMethod;
        return "POST".equalsIgnoreCase(request) || "PUT".equalsIgnoreCase(request);
    }

    public static void checkValidSOAPMessageDispatch(WSBinding binding, Service.Mode mode) {
        if (DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException("Can not create Dispatch<SOAPMessage> with XML/HTTP Binding, SOAPBinding only.");
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException("Can not create Dispatch<SOAPMessage> of Service.Mode.PAYLOAD, Service.Mode.MESSAGE only");
        }
    }

    public static void checkValidDataSourceDispatch(WSBinding binding, Service.Mode mode) {
        if (!DispatchImpl.isXMLHttp(binding)) {
            throw new WebServiceException("Can not create Dispatch<DataSource> with SOAP Binding Binding, XML/HTTP Binding only.");
        }
        if (DispatchImpl.isPAYLOADMode(mode)) {
            throw new WebServiceException("Can not create Dispatch<DataSource> of Service.Mode.PAYLOAD, Service.Mode.MESSAGE only");
        }
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        WSDLBoundPortType binding;
        if (this.endpointReference != null) {
            return EndpointReferenceUtil.transform(clazz, this.endpointReference);
        }
        PortInfo port = this.owner.safeGetPort(this.portname);
        QName portTypeName = null;
        if (port.portModel != null && (binding = port.portModel.getBinding()) != null) {
            portTypeName = binding.getPortTypeName();
        }
        this.endpointReference = EndpointReferenceUtil.getEndpointReference(clazz, this.owner.getEndpointAddress(this.portname).toString(), this.owner.getServiceName(), this.portname.getLocalPart(), portTypeName, port.portModel != null);
        return (T)this.endpointReference;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invoker
    implements Callable {
        private final T param;
        private final RequestContext rc;
        private ResponseContextReceiver receiver;

        Invoker(T param) {
            this.rc = DispatchImpl.this.requestContext.copy();
            this.param = param;
        }

        public T call() throws Exception {
            return DispatchImpl.this.doInvoke(this.param, this.rc, this.receiver);
        }

        void setReceiver(ResponseContextReceiver receiver) {
            this.receiver = receiver;
        }
    }
}

