/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client.dispatch;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.client.WSServiceDelegate;
import com.sun.xml.ws.client.dispatch.DispatchImpl;
import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.message.source.PayloadSourceMessage;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDispatch
extends DispatchImpl<DataSource> {
    public DataSourceDispatch(QName port, Class<DataSource> clazz, Service.Mode mode, WSServiceDelegate service, Pipe pipe, BindingImpl binding) {
        super(port, clazz, mode, service, pipe, binding);
    }

    @Override
    Packet createPacket(DataSource arg) {
        switch (this.mode) {
            case PAYLOAD: {
                throw new IllegalArgumentException("DataSource use is not allowed in Service.Mode.PAYLOAD\n");
            }
            case MESSAGE: {
                return new Packet(XMLMessage.create(arg));
            }
        }
        throw new WebServiceException("Unrecognized message mode");
    }

    @Override
    DataSource toReturnValue(Packet response) {
        Message message = response.getMessage();
        if (message instanceof XMLMessage.MessageDataSource) {
            XMLMessage.MessageDataSource hasDS = (XMLMessage.MessageDataSource)((Object)message);
            return hasDS.getDataSource();
        }
        if (message instanceof PayloadSourceMessage) {
            return XMLMessage.getDataSource(message);
        }
        return null;
    }
}

