/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.binding;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.HTTPBindingImpl;
import com.sun.xml.ws.binding.SOAPBindingImpl;
import com.sun.xml.ws.client.HandlerConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BindingImpl
implements WSBinding {
    private HandlerConfiguration handlerConfig;
    private final BindingID bindingId;
    private Map<String, WebServiceFeature> features;
    private AddressingVersion addressingVersion = AddressingVersion.W3C;

    protected BindingImpl(BindingID bindingId) {
        this.bindingId = bindingId;
        this.setHandlerConfig(this.createHandlerConfig(Collections.<Handler>emptyList()));
    }

    @Override
    @NotNull
    public List<Handler> getHandlerChain() {
        return this.handlerConfig.getHandlerChain();
    }

    public HandlerConfiguration getHandlerConfig() {
        return this.handlerConfig;
    }

    public void setHandlerChain(List<Handler> chain) {
        this.setHandlerConfig(this.createHandlerConfig(chain));
    }

    protected void setHandlerConfig(HandlerConfiguration handlerConfig) {
        this.handlerConfig = handlerConfig;
    }

    protected abstract HandlerConfiguration createHandlerConfig(List<Handler> var1);

    @Override
    @NotNull
    public BindingID getBindingId() {
        return this.bindingId;
    }

    @Override
    public final SOAPVersion getSOAPVersion() {
        return this.bindingId.getSOAPVersion();
    }

    @Override
    public AddressingVersion getAddressingVersion() {
        return this.addressingVersion;
    }

    @Override
    @NotNull
    public final Codec createCodec() {
        return this.bindingId.createEncoder(this);
    }

    public static BindingImpl create(@NotNull BindingID bindingId) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId);
    }

    public static BindingImpl create(@NotNull BindingID bindingId, WebServiceFeature[] features) {
        if (bindingId.equals(BindingID.XML_HTTP)) {
            return new HTTPBindingImpl();
        }
        return new SOAPBindingImpl(bindingId, features);
    }

    public static WSBinding getDefaultBinding() {
        return new SOAPBindingImpl(BindingID.SOAP11_HTTP);
    }

    @Override
    public boolean isMTOMEnabled() {
        return false;
    }

    @Override
    public void setMTOMEnabled(boolean value) {
    }

    public String getBindingID() {
        return this.bindingId.toString();
    }

    @Override
    public boolean hasFeature(String featureId) {
        if (featureId == null || this.features == null) {
            return false;
        }
        return this.features.containsKey(featureId);
    }

    private void disableFeature(WebServiceFeature feature) {
        if (feature == null || this.features == null) {
            return;
        }
        this.features.remove(feature.getID());
        this.updateCache();
    }

    private void updateCache() {
        this.addressingVersion = AddressingVersion.W3C;
    }

    private void enableFeature(WebServiceFeature feature) {
        if (feature == null) {
            return;
        }
        if (!feature.isEnabled()) {
            this.disableFeature(feature);
            return;
        }
        if (this.features == null) {
            this.features = new HashMap<String, WebServiceFeature>();
        }
        this.features.put(feature.getID(), feature);
        this.updateCache();
    }

    @Override
    public void setFeatures(WebServiceFeature[] newFeatures) {
        if (newFeatures != null) {
            for (WebServiceFeature f : newFeatures) {
                this.enableFeature(f);
            }
        }
    }

    public boolean isAddressingEnabled() {
        return this.addressingVersion != null;
    }
}

