/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.api.server;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SingletonResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstanceResolver<T> {
    @NotNull
    public abstract T resolve(Packet var1);

    public void start(@NotNull WebServiceContext wsc) {
    }

    public void dispose() {
    }

    public static <T> InstanceResolver<T> createSingleton(T singleton) {
        assert (singleton != null);
        return new SingletonResolver<T>(singleton);
    }

    @NotNull
    public Invoker createInvoker() {
        return new Invoker(){

            @Override
            public void start(@NotNull WebServiceContext wsc) {
                InstanceResolver.this.start(wsc);
            }

            @Override
            public void dispose() {
                InstanceResolver.this.dispose();
            }

            @Override
            public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
                return m.invoke(InstanceResolver.this.resolve(p), args);
            }

            @Override
            public <T> T invokeProvider(@NotNull Packet p, T arg) {
                return (T)((Provider)InstanceResolver.this.resolve(p)).invoke(arg);
            }

            public String toString() {
                return "Default Invoker over " + InstanceResolver.this.toString();
            }
        };
    }
}

